// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SuggestDictionaryConverterFactory))]
public sealed partial class SuggestDictionary<TDocument> : Elastic.Clients.Elasticsearch.IsAReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.ISuggest>>
{
	public SuggestDictionary(System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.ISuggest>> backingDictionary) : base(backingDictionary)
	{
	}

	public bool TryGetSuggest(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.ISuggest> value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetSuggest<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, ISuggest
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}

	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggest<TDocument>>? GetCompletion(string key) => TryGet<Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggest<TDocument>>(key);
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggest>? GetPhrase(string key) => TryGet<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggest>(key);
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.TermSuggest>? GetTerm(string key) => TryGet<Elastic.Clients.Elasticsearch.Core.Search.TermSuggest>(key);
	private System.Collections.Generic.IReadOnlyCollection<T>? TryGet<T>(string key) where T : class, ISuggest => BackingDictionary.TryGetValue(Sanitize(key), out var value) ? System.Linq.Enumerable.ToArray(System.Linq.Enumerable.Cast<T>(value)) : null;
}