// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.StringDistanceConverter))]
public enum StringDistance
{
	/// <summary>
	/// <para>
	/// String distance algorithm based on Damerau-Levenshtein algorithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "damerau_levenshtein")]
	DamerauLevenshtein,
	/// <summary>
	/// <para>
	/// Based on the Damerau-Levenshtein algorithm, but highly optimized for comparing string distance for terms inside the index.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "internal")]
	Internal,
	/// <summary>
	/// <para>
	/// String distance algorithm based on Jaro-Winkler algorithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "jaro_winkler")]
	JaroWinkler,
	/// <summary>
	/// <para>
	/// String distance algorithm based on the Levenshtein edit distance algorithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "levenshtein")]
	Levenshtein,
	/// <summary>
	/// <para>
	/// String distance algorithm based on character n-grams.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "ngram")]
	Ngram
}