// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class StringDistanceConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.StringDistance>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDamerauLevenshtein = System.Text.Json.JsonEncodedText.Encode("damerau_levenshtein");
	private static readonly System.Text.Json.JsonEncodedText MemberInternal = System.Text.Json.JsonEncodedText.Encode("internal");
	private static readonly System.Text.Json.JsonEncodedText MemberJaroWinkler = System.Text.Json.JsonEncodedText.Encode("jaro_winkler");
	private static readonly System.Text.Json.JsonEncodedText MemberLevenshtein = System.Text.Json.JsonEncodedText.Encode("levenshtein");
	private static readonly System.Text.Json.JsonEncodedText MemberNgram = System.Text.Json.JsonEncodedText.Encode("ngram");

	public override Elastic.Clients.Elasticsearch.Core.Search.StringDistance Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDamerauLevenshtein))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.DamerauLevenshtein;
		}

		if (reader.ValueTextEquals(MemberInternal))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Internal;
		}

		if (reader.ValueTextEquals(MemberJaroWinkler))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.JaroWinkler;
		}

		if (reader.ValueTextEquals(MemberLevenshtein))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Levenshtein;
		}

		if (reader.ValueTextEquals(MemberNgram))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Ngram;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDamerauLevenshtein.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.DamerauLevenshtein;
		}

		if (string.Equals(value, MemberInternal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Internal;
		}

		if (string.Equals(value, MemberJaroWinkler.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.JaroWinkler;
		}

		if (string.Equals(value, MemberLevenshtein.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Levenshtein;
		}

		if (string.Equals(value, MemberNgram.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Ngram;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.StringDistance)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.StringDistance value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Search.StringDistance.DamerauLevenshtein:
				writer.WriteStringValue(MemberDamerauLevenshtein);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Internal:
				writer.WriteStringValue(MemberInternal);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.StringDistance.JaroWinkler:
				writer.WriteStringValue(MemberJaroWinkler);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Levenshtein:
				writer.WriteStringValue(MemberLevenshtein);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.StringDistance.Ngram:
				writer.WriteStringValue(MemberNgram);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.StringDistance)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Search.StringDistance ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.StringDistance value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}