// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SourceFilterConverter))]
public sealed partial class SourceFilter
{
#if NET7_0_OR_GREATER
	public SourceFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SourceFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Excludes { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, vector fields are excluded from the returned source.
	/// </para>
	/// <para>
	/// This option takes precedence over <c>includes</c>: any vector field will
	/// remain excluded even if it matches an <c>includes</c> rule.
	/// </para>
	/// </summary>
	public bool? ExcludeVectors { get; set; }

	/// <summary>
	/// <para>
	/// A list of fields to include in the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Includes { get; set; }
}

public readonly partial struct SourceFilterDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Search.SourceFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceFilterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter instance) => new Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument> Excludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Excludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument> Excludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Excludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, vector fields are excluded from the returned source.
	/// </para>
	/// <para>
	/// This option takes precedence over <c>includes</c>: any vector field will
	/// remain excluded even if it matches an <c>includes</c> rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument> ExcludeVectors(bool? value = true)
	{
		Instance.ExcludeVectors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to include in the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument> Includes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Includes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to include in the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument> Includes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Includes = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SourceFilter Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SourceFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.SourceFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceFilterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter instance) => new Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor Excludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Excludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor Excludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Excludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, vector fields are excluded from the returned source.
	/// </para>
	/// <para>
	/// This option takes precedence over <c>includes</c>: any vector field will
	/// remain excluded even if it matches an <c>includes</c> rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor ExcludeVectors(bool? value = true)
	{
		Instance.ExcludeVectors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to include in the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor Includes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Includes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to include in the returned source.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor Includes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Includes = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SourceFilter Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.SourceFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}