// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SmoothingModelConverter))]
public sealed partial class SmoothingModel
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public SmoothingModel()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SmoothingModel()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SmoothingModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A smoothing model that uses an additive smoothing where a constant (typically <c>1.0</c> or smaller) is added to all counts to balance weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModel? Laplace { get => GetVariant<Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModel>("laplace"); set => SetVariant("laplace", value); }

	/// <summary>
	/// <para>
	/// A smoothing model that takes the weighted mean of the unigrams, bigrams, and trigrams based on user supplied weights (lambdas).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModel? LinearInterpolation { get => GetVariant<Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModel>("linear_interpolation"); set => SetVariant("linear_interpolation", value); }

	/// <summary>
	/// <para>
	/// A simple backoff model that backs off to lower order n-gram models if the higher order count is <c>0</c> and discounts the lower order n-gram model by a constant factor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModel? StupidBackoff { get => GetVariant<Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModel>("stupid_backoff"); set => SetVariant("stupid_backoff", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModel value) => new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel { Laplace = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModel value) => new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel { LinearInterpolation = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModel value) => new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel { StupidBackoff = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct SmoothingModelDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SmoothingModelDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SmoothingModelDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel instance) => new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A smoothing model that uses an additive smoothing where a constant (typically <c>1.0</c> or smaller) is added to all counts to balance weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor Laplace(Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModel? value)
	{
		Instance.Laplace = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A smoothing model that uses an additive smoothing where a constant (typically <c>1.0</c> or smaller) is added to all counts to balance weights.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor Laplace(System.Action<Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModelDescriptor> action)
	{
		Instance.Laplace = Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModelDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A smoothing model that takes the weighted mean of the unigrams, bigrams, and trigrams based on user supplied weights (lambdas).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor LinearInterpolation(Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModel? value)
	{
		Instance.LinearInterpolation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A smoothing model that takes the weighted mean of the unigrams, bigrams, and trigrams based on user supplied weights (lambdas).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor LinearInterpolation(System.Action<Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModelDescriptor> action)
	{
		Instance.LinearInterpolation = Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModelDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A simple backoff model that backs off to lower order n-gram models if the higher order count is <c>0</c> and discounts the lower order n-gram model by a constant factor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor StupidBackoff(Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModel? value)
	{
		Instance.StupidBackoff = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A simple backoff model that backs off to lower order n-gram models if the higher order count is <c>0</c> and discounts the lower order n-gram model by a constant factor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor StupidBackoff(System.Action<Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModelDescriptor> action)
	{
		Instance.StupidBackoff = Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModelDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModelDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}