// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class SmoothingModelConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel>
{
	private static readonly System.Text.Json.JsonEncodedText VariantLaplace = System.Text.Json.JsonEncodedText.Encode("laplace");
	private static readonly System.Text.Json.JsonEncodedText VariantLinearInterpolation = System.Text.Json.JsonEncodedText.Encode("linear_interpolation");
	private static readonly System.Text.Json.JsonEncodedText VariantStupidBackoff = System.Text.Json.JsonEncodedText.Encode("stupid_backoff");

	public override Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantLaplace))
			{
				variantType = VariantLaplace.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModel>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantLinearInterpolation))
			{
				variantType = VariantLinearInterpolation.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModel>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantStupidBackoff))
			{
				variantType = VariantStupidBackoff.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModel>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "laplace":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Core.Search.LaplaceSmoothingModel)value.Variant, null, null);
				break;
			case "linear_interpolation":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Core.Search.LinearInterpolationSmoothingModel)value.Variant, null, null);
				break;
			case "stupid_backoff":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Core.Search.StupidBackoffSmoothingModel)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel)}'.");
		}

		writer.WriteEndObject();
	}
}