// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.ScoreModeConverter))]
public enum ScoreMode
{
	/// <summary>
	/// <para>
	/// Average the original score and the rescore query score.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "avg")]
	Avg,
	/// <summary>
	/// <para>
	/// Take the max of original score and the rescore query score.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "max")]
	Max,
	/// <summary>
	/// <para>
	/// Take the min of the original score and the rescore query score.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "min")]
	Min,
	/// <summary>
	/// <para>
	/// Multiply the original score by the rescore query score.
	/// Useful for <c>function</c> query rescores.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "multiply")]
	Multiply,
	/// <summary>
	/// <para>
	/// Add the original score and the rescore query score.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "total")]
	Total
}