// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class ScoreModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.ScoreMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText MemberMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText MemberMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText MemberMultiply = System.Text.Json.JsonEncodedText.Encode("multiply");
	private static readonly System.Text.Json.JsonEncodedText MemberTotal = System.Text.Json.JsonEncodedText.Encode("total");

	public override Elastic.Clients.Elasticsearch.Core.Search.ScoreMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAvg))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Avg;
		}

		if (reader.ValueTextEquals(MemberMax))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Max;
		}

		if (reader.ValueTextEquals(MemberMin))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Min;
		}

		if (reader.ValueTextEquals(MemberMultiply))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Multiply;
		}

		if (reader.ValueTextEquals(MemberTotal))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Total;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAvg.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Avg;
		}

		if (string.Equals(value, MemberMax.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Max;
		}

		if (string.Equals(value, MemberMin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Min;
		}

		if (string.Equals(value, MemberMultiply.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Multiply;
		}

		if (string.Equals(value, MemberTotal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Total;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.ScoreMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.ScoreMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Avg:
				writer.WriteStringValue(MemberAvg);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Max:
				writer.WriteStringValue(MemberMax);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Min:
				writer.WriteStringValue(MemberMin);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Multiply:
				writer.WriteStringValue(MemberMultiply);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.ScoreMode.Total:
				writer.WriteStringValue(MemberTotal);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.ScoreMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Search.ScoreMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.ScoreMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}