// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.RescoreConverter))]
public sealed partial class Rescore
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public Rescore()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Rescore()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Rescore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.LearningToRank? LearningToRank { get => GetVariant<Elastic.Clients.Elasticsearch.Core.Search.LearningToRank>("learning_to_rank"); set => SetVariant("learning_to_rank", value); }
	public Elastic.Clients.Elasticsearch.Core.Search.RescoreQuery? Query { get => GetVariant<Elastic.Clients.Elasticsearch.Core.Search.RescoreQuery>("query"); set => SetVariant("query", value); }
	public int? WindowSize { get; set; }

	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Core.Search.LearningToRank value) => new Elastic.Clients.Elasticsearch.Core.Search.Rescore { LearningToRank = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Core.Search.RescoreQuery value) => new Elastic.Clients.Elasticsearch.Core.Search.Rescore { Query = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct RescoreDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Search.Rescore Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreDescriptor(Elastic.Clients.Elasticsearch.Core.Search.Rescore instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Search.Rescore instance) => new Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument> LearningToRank(Elastic.Clients.Elasticsearch.Core.Search.LearningToRank? value)
	{
		Instance.LearningToRank = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument> LearningToRank(System.Action<Elastic.Clients.Elasticsearch.Core.Search.LearningToRankDescriptor> action)
	{
		Instance.LearningToRank = Elastic.Clients.Elasticsearch.Core.Search.LearningToRankDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.Core.Search.RescoreQuery? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreQueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Core.Search.RescoreQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument> WindowSize(int? value)
	{
		Instance.WindowSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.Rescore Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RescoreDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.Rescore Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreDescriptor(Elastic.Clients.Elasticsearch.Core.Search.Rescore instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RescoreDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor(Elastic.Clients.Elasticsearch.Core.Search.Rescore instance) => new Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor LearningToRank(Elastic.Clients.Elasticsearch.Core.Search.LearningToRank? value)
	{
		Instance.LearningToRank = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor LearningToRank(System.Action<Elastic.Clients.Elasticsearch.Core.Search.LearningToRankDescriptor> action)
	{
		Instance.LearningToRank = Elastic.Clients.Elasticsearch.Core.Search.LearningToRankDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor Query(Elastic.Clients.Elasticsearch.Core.Search.RescoreQuery? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreQueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Core.Search.RescoreQueryDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreQueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Core.Search.RescoreQueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor WindowSize(int? value)
	{
		Instance.WindowSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.Rescore Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.Rescore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}