// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.RegexOptionsConverter))]
public sealed partial class RegexOptions
{
#if NET7_0_OR_GREATER
	public RegexOptions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RegexOptions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RegexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Optional operators for the regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<int, string>? Flags { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public int? MaxDeterminizedStates { get; set; }
}

public readonly partial struct RegexOptionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.RegexOptions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexOptionsDescriptor(Elastic.Clients.Elasticsearch.Core.Search.RegexOptions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RegexOptionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.RegexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor(Elastic.Clients.Elasticsearch.Core.Search.RegexOptions instance) => new Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.RegexOptions(Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Optional operators for the regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor Flags(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.Flags = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of automaton states required for the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor MaxDeterminizedStates(int? value)
	{
		Instance.MaxDeterminizedStates = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.RegexOptions Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.RegexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.RegexOptions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}