// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class PhraseSuggesterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggester>
{
	private static readonly System.Text.Json.JsonEncodedText PropAnalyzer = System.Text.Json.JsonEncodedText.Encode("analyzer");
	private static readonly System.Text.Json.JsonEncodedText PropCollate = System.Text.Json.JsonEncodedText.Encode("collate");
	private static readonly System.Text.Json.JsonEncodedText PropConfidence = System.Text.Json.JsonEncodedText.Encode("confidence");
	private static readonly System.Text.Json.JsonEncodedText PropDirectGenerator = System.Text.Json.JsonEncodedText.Encode("direct_generator");
	private static readonly System.Text.Json.JsonEncodedText PropField = System.Text.Json.JsonEncodedText.Encode("field");
	private static readonly System.Text.Json.JsonEncodedText PropForceUnigrams = System.Text.Json.JsonEncodedText.Encode("force_unigrams");
	private static readonly System.Text.Json.JsonEncodedText PropGramSize = System.Text.Json.JsonEncodedText.Encode("gram_size");
	private static readonly System.Text.Json.JsonEncodedText PropHighlight = System.Text.Json.JsonEncodedText.Encode("highlight");
	private static readonly System.Text.Json.JsonEncodedText PropMaxErrors = System.Text.Json.JsonEncodedText.Encode("max_errors");
	private static readonly System.Text.Json.JsonEncodedText PropRealWordErrorLikelihood = System.Text.Json.JsonEncodedText.Encode("real_word_error_likelihood");
	private static readonly System.Text.Json.JsonEncodedText PropSeparator = System.Text.Json.JsonEncodedText.Encode("separator");
	private static readonly System.Text.Json.JsonEncodedText PropShardSize = System.Text.Json.JsonEncodedText.Encode("shard_size");
	private static readonly System.Text.Json.JsonEncodedText PropSize = System.Text.Json.JsonEncodedText.Encode("size");
	private static readonly System.Text.Json.JsonEncodedText PropSmoothing = System.Text.Json.JsonEncodedText.Encode("smoothing");
	private static readonly System.Text.Json.JsonEncodedText PropText = System.Text.Json.JsonEncodedText.Encode("text");
	private static readonly System.Text.Json.JsonEncodedText PropTokenLimit = System.Text.Json.JsonEncodedText.Encode("token_limit");

	public override Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggester Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAnalyzer = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate?> propCollate = default;
		LocalJsonValue<double?> propConfidence = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.DirectGenerator>?> propDirectGenerator = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field> propField = default;
		LocalJsonValue<bool?> propForceUnigrams = default;
		LocalJsonValue<int?> propGramSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight?> propHighlight = default;
		LocalJsonValue<double?> propMaxErrors = default;
		LocalJsonValue<double?> propRealWordErrorLikelihood = default;
		LocalJsonValue<string?> propSeparator = default;
		LocalJsonValue<int?> propShardSize = default;
		LocalJsonValue<int?> propSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.SmoothingModel?> propSmoothing = default;
		LocalJsonValue<string?> propText = default;
		LocalJsonValue<int?> propTokenLimit = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAnalyzer.TryReadProperty(ref reader, options, PropAnalyzer, null))
			{
				continue;
			}

			if (propCollate.TryReadProperty(ref reader, options, PropCollate, null))
			{
				continue;
			}

			if (propConfidence.TryReadProperty(ref reader, options, PropConfidence, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propDirectGenerator.TryReadProperty(ref reader, options, PropDirectGenerator, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.DirectGenerator>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Core.Search.DirectGenerator>(o, null)))
			{
				continue;
			}

			if (propField.TryReadProperty(ref reader, options, PropField, null))
			{
				continue;
			}

			if (propForceUnigrams.TryReadProperty(ref reader, options, PropForceUnigrams, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propGramSize.TryReadProperty(ref reader, options, PropGramSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propHighlight.TryReadProperty(ref reader, options, PropHighlight, null))
			{
				continue;
			}

			if (propMaxErrors.TryReadProperty(ref reader, options, PropMaxErrors, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propRealWordErrorLikelihood.TryReadProperty(ref reader, options, PropRealWordErrorLikelihood, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propSeparator.TryReadProperty(ref reader, options, PropSeparator, null))
			{
				continue;
			}

			if (propShardSize.TryReadProperty(ref reader, options, PropShardSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSize.TryReadProperty(ref reader, options, PropSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSmoothing.TryReadProperty(ref reader, options, PropSmoothing, null))
			{
				continue;
			}

			if (propText.TryReadProperty(ref reader, options, PropText, null))
			{
				continue;
			}

			if (propTokenLimit.TryReadProperty(ref reader, options, PropTokenLimit, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Analyzer = propAnalyzer.Value,
			Collate = propCollate.Value,
			Confidence = propConfidence.Value,
			DirectGenerator = propDirectGenerator.Value,
			Field = propField.Value,
			ForceUnigrams = propForceUnigrams.Value,
			GramSize = propGramSize.Value,
			Highlight = propHighlight.Value,
			MaxErrors = propMaxErrors.Value,
			RealWordErrorLikelihood = propRealWordErrorLikelihood.Value,
			Separator = propSeparator.Value,
			ShardSize = propShardSize.Value,
			Size = propSize.Value,
			Smoothing = propSmoothing.Value,
			Text = propText.Value,
			TokenLimit = propTokenLimit.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggester value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAnalyzer, value.Analyzer, null, null);
		writer.WriteProperty(options, PropCollate, value.Collate, null, null);
		writer.WriteProperty(options, PropConfidence, value.Confidence, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropDirectGenerator, value.DirectGenerator, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.DirectGenerator>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Core.Search.DirectGenerator>(o, v, null));
		writer.WriteProperty(options, PropField, value.Field, null, null);
		writer.WriteProperty(options, PropForceUnigrams, value.ForceUnigrams, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropGramSize, value.GramSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropHighlight, value.Highlight, null, null);
		writer.WriteProperty(options, PropMaxErrors, value.MaxErrors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropRealWordErrorLikelihood, value.RealWordErrorLikelihood, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropSeparator, value.Separator, null, null);
		writer.WriteProperty(options, PropShardSize, value.ShardSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSize, value.Size, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSmoothing, value.Smoothing, null, null);
		writer.WriteProperty(options, PropText, value.Text, null, null);
		writer.WriteProperty(options, PropTokenLimit, value.TokenLimit, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteEndObject();
	}
}