// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.PhraseSuggestHighlightConverter))]
public sealed partial class PhraseSuggestHighlight
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhraseSuggestHighlight(string postTag, string preTag)
	{
		PostTag = postTag;
		PreTag = preTag;
	}
#if NET7_0_OR_GREATER
	public PhraseSuggestHighlight()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PhraseSuggestHighlight()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PhraseSuggestHighlight(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Use in conjunction with <c>pre_tag</c> to define the HTML tags to use for the highlighted text.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string PostTag { get; set; }

	/// <summary>
	/// <para>
	/// Use in conjunction with <c>post_tag</c> to define the HTML tags to use for the highlighted text.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string PreTag { get; set; }
}

public readonly partial struct PhraseSuggestHighlightDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhraseSuggestHighlightDescriptor(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhraseSuggestHighlightDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight instance) => new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Use in conjunction with <c>pre_tag</c> to define the HTML tags to use for the highlighted text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor PostTag(string value)
	{
		Instance.PostTag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use in conjunction with <c>post_tag</c> to define the HTML tags to use for the highlighted text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor PreTag(string value)
	{
		Instance.PreTag = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlightDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestHighlight(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}