// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.PhraseSuggestCollateConverter))]
public sealed partial class PhraseSuggestCollate
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhraseSuggestCollate(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateQuery query)
	{
		Query = query;
	}
#if NET7_0_OR_GREATER
	public PhraseSuggestCollate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PhraseSuggestCollate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PhraseSuggestCollate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Parameters to use if the query is templated.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Params { get; set; }

	/// <summary>
	/// <para>
	/// Returns all suggestions with an extra <c>collate_match</c> option indicating whether the generated phrase matched any document.
	/// </para>
	/// </summary>
	public bool? Prune { get; set; }

	/// <summary>
	/// <para>
	/// A collate query that is run once for every suggestion.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateQuery Query { get; set; }
}

public readonly partial struct PhraseSuggestCollateDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhraseSuggestCollateDescriptor(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PhraseSuggestCollateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate instance) => new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Parameters to use if the query is templated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Parameters to use if the query is templated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Parameters to use if the query is templated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Returns all suggestions with an extra <c>collate_match</c> option indicating whether the generated phrase matched any document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Prune(bool? value = true)
	{
		Instance.Prune = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A collate query that is run once for every suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Query(Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateQuery value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A collate query that is run once for every suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Query()
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateQueryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A collate query that is run once for every suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateQueryDescriptor>? action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateQueryDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollateDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggestCollate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}