// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.InnerHitsConverter))]
public sealed partial class InnerHits
{
#if NET7_0_OR_GREATER
	public InnerHits()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InnerHits()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? Collapse { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? DocvalueFields { get; set; }
	public bool? Explain { get; set; }
	public Elastic.Clients.Elasticsearch.Fields? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Inner hit starting document offset.
	/// </para>
	/// </summary>
	public int? From { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.Highlight? Highlight { get; set; }
	public bool? IgnoreUnmapped { get; set; }

	/// <summary>
	/// <para>
	/// The name for the particular inner hit definition in the response.
	/// Useful when a search request contains multiple inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Name { get; set; }
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>? ScriptFields { get; set; }
	public bool? SeqNoPrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of hits to return per <c>inner_hits</c>.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? Source { get; set; }
	public Elastic.Clients.Elasticsearch.Fields? StoredFields { get; set; }
	public bool? TrackScores { get; set; }
	public bool? Version { get; set; }
}

public readonly partial struct InnerHitsDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Search.InnerHits Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InnerHitsDescriptor(Elastic.Clients.Elasticsearch.Core.Search.InnerHits instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InnerHitsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Search.InnerHits instance) => new Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner hit starting document offset.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name for the particular inner hit definition in the response.
	/// Useful when a search request contains multiple inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> ScriptFields(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField<TDocument>>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> AddScriptField(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> AddScriptField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> AddScriptField(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> AddScriptField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of hits to return per <c>inner_hits</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> StoredFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument> Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.InnerHits Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InnerHitsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.InnerHits Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InnerHitsDescriptor(Elastic.Clients.Elasticsearch.Core.Search.InnerHits instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InnerHitsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor(Elastic.Clients.Elasticsearch.Core.Search.InnerHits instance) => new Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Collapse<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor DocvalueFields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner hit starting document offset.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Highlight<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name for the particular inner hit definition in the response.
	/// Useful when a search request contains multiple inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor ScriptFields(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor ScriptFields<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField<T>>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldScriptField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor AddScriptField(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor AddScriptField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor AddScriptField(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor AddScriptField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of hits to return per <c>inner_hits</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// How the inner hits should be sorted per <c>inner_hits</c>.
	/// By default, inner hits are sorted by score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Source<T>(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor StoredFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.InnerHits Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.InnerHits(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}