// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.HighlighterTypeConverter))]
public readonly partial struct HighlighterType : Elastic.Clients.Elasticsearch.Serialization.IEnumStruct<Elastic.Clients.Elasticsearch.Core.Search.HighlighterType>
{
	public HighlighterType(string value) => Value = value;
#if NET7_0_OR_GREATER
	static HighlighterType IEnumStruct<HighlighterType>.Create(string value) => value;
#else
	HighlighterType IEnumStruct<HighlighterType>.Create(string value) => value;
#endif
	public readonly string Value { get; }

	/// <summary>
	/// <para>
	/// The fvh highlighter uses the Lucene Fast Vector highlighter.
	/// </para>
	/// </summary>
	public static HighlighterType FastVector { get; } = new HighlighterType("fvh");

	/// <summary>
	/// <para>
	/// The <c>plain</c> highlighter uses the standard Lucene highlighter
	/// </para>
	/// </summary>
	public static HighlighterType Plain { get; } = new HighlighterType("plain");

	/// <summary>
	/// <para>
	/// The unified highlighter uses the Lucene Unified Highlighter.
	/// </para>
	/// </summary>
	public static HighlighterType Unified { get; } = new HighlighterType("unified");

	public override string ToString() => Value ?? string.Empty;

	public static implicit operator string(HighlighterType @enum) => @enum.Value;
	public static implicit operator HighlighterType(string value) => new(value);

	public override int GetHashCode() => Value.GetHashCode();
	public override bool Equals(object obj) => obj is HighlighterType other && this.Equals(other);
	public bool Equals(HighlighterType other) => Value == other.Value;

	public static bool operator ==(HighlighterType a, HighlighterType b) => a.Equals(b);
	public static bool operator !=(HighlighterType a, HighlighterType b) => !(a == b);
}