// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class HighlighterFragmenterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter>
{
	private static readonly System.Text.Json.JsonEncodedText MemberSimple = System.Text.Json.JsonEncodedText.Encode("simple");
	private static readonly System.Text.Json.JsonEncodedText MemberSpan = System.Text.Json.JsonEncodedText.Encode("span");

	public override Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberSimple))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter.Simple;
		}

		if (reader.ValueTextEquals(MemberSpan))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter.Span;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberSimple.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter.Simple;
		}

		if (string.Equals(value, MemberSpan.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter.Span;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter.Simple:
				writer.WriteStringValue(MemberSimple);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter.Span:
				writer.WriteStringValue(MemberSpan);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}