// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class HighlighterEncoderConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDefault = System.Text.Json.JsonEncodedText.Encode("default");
	private static readonly System.Text.Json.JsonEncodedText MemberHtml = System.Text.Json.JsonEncodedText.Encode("html");

	public override Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDefault))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder.Default;
		}

		if (reader.ValueTextEquals(MemberHtml))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder.Html;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDefault.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder.Default;
		}

		if (string.Equals(value, MemberHtml.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder.Html;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder.Default:
				writer.WriteStringValue(MemberDefault);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder.Html:
				writer.WriteStringValue(MemberHtml);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.HighlighterEncoder value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}