// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class HighlightFieldConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.HighlightField>
{
	private static readonly System.Text.Json.JsonEncodedText PropBoundaryChars = System.Text.Json.JsonEncodedText.Encode("boundary_chars");
	private static readonly System.Text.Json.JsonEncodedText PropBoundaryMaxScan = System.Text.Json.JsonEncodedText.Encode("boundary_max_scan");
	private static readonly System.Text.Json.JsonEncodedText PropBoundaryScanner = System.Text.Json.JsonEncodedText.Encode("boundary_scanner");
	private static readonly System.Text.Json.JsonEncodedText PropBoundaryScannerLocale = System.Text.Json.JsonEncodedText.Encode("boundary_scanner_locale");
	private static readonly System.Text.Json.JsonEncodedText PropForceSource = System.Text.Json.JsonEncodedText.Encode("force_source");
	private static readonly System.Text.Json.JsonEncodedText PropFragmenter = System.Text.Json.JsonEncodedText.Encode("fragmenter");
	private static readonly System.Text.Json.JsonEncodedText PropFragmentOffset = System.Text.Json.JsonEncodedText.Encode("fragment_offset");
	private static readonly System.Text.Json.JsonEncodedText PropFragmentSize = System.Text.Json.JsonEncodedText.Encode("fragment_size");
	private static readonly System.Text.Json.JsonEncodedText PropHighlightFilter = System.Text.Json.JsonEncodedText.Encode("highlight_filter");
	private static readonly System.Text.Json.JsonEncodedText PropHighlightQuery = System.Text.Json.JsonEncodedText.Encode("highlight_query");
	private static readonly System.Text.Json.JsonEncodedText PropMatchedFields = System.Text.Json.JsonEncodedText.Encode("matched_fields");
	private static readonly System.Text.Json.JsonEncodedText PropMaxAnalyzedOffset = System.Text.Json.JsonEncodedText.Encode("max_analyzed_offset");
	private static readonly System.Text.Json.JsonEncodedText PropMaxFragmentLength = System.Text.Json.JsonEncodedText.Encode("max_fragment_length");
	private static readonly System.Text.Json.JsonEncodedText PropNoMatchSize = System.Text.Json.JsonEncodedText.Encode("no_match_size");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfFragments = System.Text.Json.JsonEncodedText.Encode("number_of_fragments");
	private static readonly System.Text.Json.JsonEncodedText PropOptions = System.Text.Json.JsonEncodedText.Encode("options");
	private static readonly System.Text.Json.JsonEncodedText PropOrder = System.Text.Json.JsonEncodedText.Encode("order");
	private static readonly System.Text.Json.JsonEncodedText PropPhraseLimit = System.Text.Json.JsonEncodedText.Encode("phrase_limit");
	private static readonly System.Text.Json.JsonEncodedText PropPostTags = System.Text.Json.JsonEncodedText.Encode("post_tags");
	private static readonly System.Text.Json.JsonEncodedText PropPreTags = System.Text.Json.JsonEncodedText.Encode("pre_tags");
	private static readonly System.Text.Json.JsonEncodedText PropRequireFieldMatch = System.Text.Json.JsonEncodedText.Encode("require_field_match");
	private static readonly System.Text.Json.JsonEncodedText PropTagsSchema = System.Text.Json.JsonEncodedText.Encode("tags_schema");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.Core.Search.HighlightField Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propBoundaryChars = default;
		LocalJsonValue<int?> propBoundaryMaxScan = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner?> propBoundaryScanner = default;
		LocalJsonValue<string?> propBoundaryScannerLocale = default;
		LocalJsonValue<bool?> propForceSource = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter?> propFragmenter = default;
		LocalJsonValue<int?> propFragmentOffset = default;
		LocalJsonValue<int?> propFragmentSize = default;
		LocalJsonValue<bool?> propHighlightFilter = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.QueryDsl.Query?> propHighlightQuery = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Fields?> propMatchedFields = default;
		LocalJsonValue<int?> propMaxAnalyzedOffset = default;
		LocalJsonValue<int?> propMaxFragmentLength = default;
		LocalJsonValue<int?> propNoMatchSize = default;
		LocalJsonValue<int?> propNumberOfFragments = default;
		LocalJsonValue<System.Collections.Generic.IDictionary<string, object>?> propOptions = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterOrder?> propOrder = default;
		LocalJsonValue<int?> propPhraseLimit = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propPostTags = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propPreTags = default;
		LocalJsonValue<bool?> propRequireFieldMatch = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterTagsSchema?> propTagsSchema = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterType?> propType = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBoundaryChars.TryReadProperty(ref reader, options, PropBoundaryChars, null))
			{
				continue;
			}

			if (propBoundaryMaxScan.TryReadProperty(ref reader, options, PropBoundaryMaxScan, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propBoundaryScanner.TryReadProperty(ref reader, options, PropBoundaryScanner, static Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner>(o)))
			{
				continue;
			}

			if (propBoundaryScannerLocale.TryReadProperty(ref reader, options, PropBoundaryScannerLocale, null))
			{
				continue;
			}

			if (propForceSource.TryReadProperty(ref reader, options, PropForceSource, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propFragmenter.TryReadProperty(ref reader, options, PropFragmenter, static Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter>(o)))
			{
				continue;
			}

			if (propFragmentOffset.TryReadProperty(ref reader, options, PropFragmentOffset, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propFragmentSize.TryReadProperty(ref reader, options, PropFragmentSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propHighlightFilter.TryReadProperty(ref reader, options, PropHighlightFilter, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propHighlightQuery.TryReadProperty(ref reader, options, PropHighlightQuery, null))
			{
				continue;
			}

			if (propMatchedFields.TryReadProperty(ref reader, options, PropMatchedFields, static Elastic.Clients.Elasticsearch.Fields? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<Elastic.Clients.Elasticsearch.Fields?>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SingleOrManyFieldsMarker))))
			{
				continue;
			}

			if (propMaxAnalyzedOffset.TryReadProperty(ref reader, options, PropMaxAnalyzedOffset, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxFragmentLength.TryReadProperty(ref reader, options, PropMaxFragmentLength, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNoMatchSize.TryReadProperty(ref reader, options, PropNoMatchSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNumberOfFragments.TryReadProperty(ref reader, options, PropNumberOfFragments, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propOptions.TryReadProperty(ref reader, options, PropOptions, static System.Collections.Generic.IDictionary<string, object>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, object>(o, null, static object (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<object>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))!)))
			{
				continue;
			}

			if (propOrder.TryReadProperty(ref reader, options, PropOrder, static Elastic.Clients.Elasticsearch.Core.Search.HighlighterOrder? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterOrder>(o)))
			{
				continue;
			}

			if (propPhraseLimit.TryReadProperty(ref reader, options, PropPhraseLimit, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propPostTags.TryReadProperty(ref reader, options, PropPostTags, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propPreTags.TryReadProperty(ref reader, options, PropPreTags, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propRequireFieldMatch.TryReadProperty(ref reader, options, PropRequireFieldMatch, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propTagsSchema.TryReadProperty(ref reader, options, PropTagsSchema, static Elastic.Clients.Elasticsearch.Core.Search.HighlighterTagsSchema? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterTagsSchema>(o)))
			{
				continue;
			}

			if (propType.TryReadProperty(ref reader, options, PropType, static Elastic.Clients.Elasticsearch.Core.Search.HighlighterType? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterType>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.Search.HighlightField(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BoundaryChars = propBoundaryChars.Value,
			BoundaryMaxScan = propBoundaryMaxScan.Value,
			BoundaryScanner = propBoundaryScanner.Value,
			BoundaryScannerLocale = propBoundaryScannerLocale.Value,
			ForceSource = propForceSource.Value,
			Fragmenter = propFragmenter.Value,
			FragmentOffset = propFragmentOffset.Value,
			FragmentSize = propFragmentSize.Value,
			HighlightFilter = propHighlightFilter.Value,
			HighlightQuery = propHighlightQuery.Value,
			MatchedFields = propMatchedFields.Value,
			MaxAnalyzedOffset = propMaxAnalyzedOffset.Value,
			MaxFragmentLength = propMaxFragmentLength.Value,
			NoMatchSize = propNoMatchSize.Value,
			NumberOfFragments = propNumberOfFragments.Value,
			Options = propOptions.Value,
			Order = propOrder.Value,
			PhraseLimit = propPhraseLimit.Value,
			PostTags = propPostTags.Value,
			PreTags = propPreTags.Value,
			RequireFieldMatch = propRequireFieldMatch.Value,
			TagsSchema = propTagsSchema.Value,
			Type = propType.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.HighlightField value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBoundaryChars, value.BoundaryChars, null, null);
		writer.WriteProperty(options, PropBoundaryMaxScan, value.BoundaryMaxScan, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropBoundaryScanner, value.BoundaryScanner, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner>(o, v));
		writer.WriteProperty(options, PropBoundaryScannerLocale, value.BoundaryScannerLocale, null, null);
		writer.WriteProperty(options, PropForceSource, value.ForceSource, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropFragmenter, value.Fragmenter, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterFragmenter>(o, v));
		writer.WriteProperty(options, PropFragmentOffset, value.FragmentOffset, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropFragmentSize, value.FragmentSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropHighlightFilter, value.HighlightFilter, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropHighlightQuery, value.HighlightQuery, null, null);
		writer.WriteProperty(options, PropMatchedFields, value.MatchedFields, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Fields? v) => w.WriteValueEx<Elastic.Clients.Elasticsearch.Fields?>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SingleOrManyFieldsMarker)));
		writer.WriteProperty(options, PropMaxAnalyzedOffset, value.MaxAnalyzedOffset, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxFragmentLength, value.MaxFragmentLength, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNoMatchSize, value.NoMatchSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNumberOfFragments, value.NumberOfFragments, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropOptions, value.Options, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, object>? v) => w.WriteDictionaryValue<string, object>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, object v) => w.WriteValueEx<object>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))));
		writer.WriteProperty(options, PropOrder, value.Order, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Core.Search.HighlighterOrder? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterOrder>(o, v));
		writer.WriteProperty(options, PropPhraseLimit, value.PhraseLimit, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropPostTags, value.PostTags, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropPreTags, value.PreTags, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropRequireFieldMatch, value.RequireFieldMatch, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropTagsSchema, value.TagsSchema, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Core.Search.HighlighterTagsSchema? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterTagsSchema>(o, v));
		writer.WriteProperty(options, PropType, value.Type, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Core.Search.HighlighterType? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Core.Search.HighlighterType>(o, v));
		writer.WriteEndObject();
	}
}