// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class FieldSuggesterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>
{
	private static readonly System.Text.Json.JsonEncodedText PropPrefix = System.Text.Json.JsonEncodedText.Encode("prefix");
	private static readonly System.Text.Json.JsonEncodedText PropRegex = System.Text.Json.JsonEncodedText.Encode("regex");
	private static readonly System.Text.Json.JsonEncodedText PropText = System.Text.Json.JsonEncodedText.Encode("text");
	private static readonly System.Text.Json.JsonEncodedText VariantCompletion = System.Text.Json.JsonEncodedText.Encode("completion");
	private static readonly System.Text.Json.JsonEncodedText VariantPhrase = System.Text.Json.JsonEncodedText.Encode("phrase");
	private static readonly System.Text.Json.JsonEncodedText VariantTerm = System.Text.Json.JsonEncodedText.Encode("term");

	public override Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propPrefix = default;
		LocalJsonValue<string?> propRegex = default;
		LocalJsonValue<string?> propText = default;
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propPrefix.TryReadProperty(ref reader, options, PropPrefix, null))
			{
				continue;
			}

			if (propRegex.TryReadProperty(ref reader, options, PropRegex, null))
			{
				continue;
			}

			if (propText.TryReadProperty(ref reader, options, PropText, null))
			{
				continue;
			}

			if (reader.ValueTextEquals(VariantCompletion))
			{
				variantType = VariantCompletion.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPhrase))
			{
				variantType = VariantPhrase.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggester>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerm))
			{
				variantType = VariantTerm.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Core.Search.TermSuggester>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant,
			Prefix = propPrefix.Value,
			Regex = propRegex.Value,
			Text = propText.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "completion":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester)value.Variant, null, null);
				break;
			case "phrase":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Core.Search.PhraseSuggester)value.Variant, null, null);
				break;
			case "term":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Core.Search.TermSuggester)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester)}'.");
		}

		writer.WriteProperty(options, PropPrefix, value.Prefix, null, null);
		writer.WriteProperty(options, PropRegex, value.Regex, null, null);
		writer.WriteProperty(options, PropText, value.Text, null, null);
		writer.WriteEndObject();
	}
}