// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.CompletionSuggesterConverter))]
public sealed partial class CompletionSuggester
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionSuggester(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public CompletionSuggester()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CompletionSuggester()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CompletionSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The analyzer to analyze the suggest text with.
	/// Defaults to the search analyzer of the suggest field.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>? Contexts { get; set; }

	/// <summary>
	/// <para>
	/// The field to fetch the candidate suggestions from.
	/// Needs to be set globally or per suggestion.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness? Fuzzy { get; set; }

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.RegexOptions? Regex { get; set; }

	/// <summary>
	/// <para>
	/// The maximum corrections to be returned per suggest text token.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// Whether duplicate suggestions should be filtered out.
	/// </para>
	/// </summary>
	public bool? SkipDuplicates { get; set; }
}

public readonly partial struct CompletionSuggesterDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionSuggesterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionSuggesterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester instance) => new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester(Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The analyzer to analyze the suggest text with.
	/// Defaults to the search analyzer of the suggest field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Contexts(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>? value)
	{
		Instance.Contexts = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Contexts()
	{
		Instance.Contexts = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Contexts(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext<TDocument>>? action)
	{
		Instance.Contexts = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> AddContext(Elastic.Clients.Elasticsearch.Field key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext> value)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> AddContext(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext> value)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> AddContext(Elastic.Clients.Elasticsearch.Field key, params Elastic.Clients.Elasticsearch.Core.Search.CompletionContext[] values)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, [.. values]);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> AddContext(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, params Elastic.Clients.Elasticsearch.Core.Search.CompletionContext[] values)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, [.. values]);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> AddContext(Elastic.Clients.Elasticsearch.Field key, params System.Action<Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor.Build(action));
		}

		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, items);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> AddContext(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, params System.Action<Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor.Build(action));
		}

		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, items);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to fetch the candidate suggestions from.
	/// Needs to be set globally or per suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to fetch the candidate suggestions from.
	/// Needs to be set globally or per suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Fuzzy(Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness? value)
	{
		Instance.Fuzzy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Fuzzy()
	{
		Instance.Fuzzy = Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Fuzzy(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor>? action)
	{
		Instance.Fuzzy = Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Regex(Elastic.Clients.Elasticsearch.Core.Search.RegexOptions? value)
	{
		Instance.Regex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Regex()
	{
		Instance.Regex = Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Regex(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor>? action)
	{
		Instance.Regex = Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum corrections to be returned per suggest text token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether duplicate suggestions should be filtered out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument> SkipDuplicates(bool? value = true)
	{
		Instance.SkipDuplicates = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct CompletionSuggesterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionSuggesterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CompletionSuggesterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester instance) => new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester(Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The analyzer to analyze the suggest text with.
	/// Defaults to the search analyzer of the suggest field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Contexts(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>? value)
	{
		Instance.Contexts = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Contexts()
	{
		Instance.Contexts = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Contexts(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext>? action)
	{
		Instance.Contexts = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A value, geo point object, or a geo hash string to filter or boost the suggestion on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Contexts<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext<T>>? action)
	{
		Instance.Contexts = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldCollectionOfCompletionContext<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor AddContext(Elastic.Clients.Elasticsearch.Field key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext> value)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor AddContext<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext> value)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor AddContext(Elastic.Clients.Elasticsearch.Field key, params Elastic.Clients.Elasticsearch.Core.Search.CompletionContext[] values)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, [.. values]);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor AddContext<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, params Elastic.Clients.Elasticsearch.Core.Search.CompletionContext[] values)
	{
		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, [.. values]);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor AddContext(Elastic.Clients.Elasticsearch.Field key, params System.Action<Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor.Build(action));
		}

		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, items);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor AddContext<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, params System.Action<Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.CompletionContextDescriptor.Build(action));
		}

		Instance.Contexts ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.CompletionContext>>();
		Instance.Contexts.Add(key, items);
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to fetch the candidate suggestions from.
	/// Needs to be set globally or per suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to fetch the candidate suggestions from.
	/// Needs to be set globally or per suggestion.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Fuzzy(Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness? value)
	{
		Instance.Fuzzy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Fuzzy()
	{
		Instance.Fuzzy = Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enables fuzziness, meaning you can have a typo in your search and still get results back.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Fuzzy(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor>? action)
	{
		Instance.Fuzzy = Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Regex(Elastic.Clients.Elasticsearch.Core.Search.RegexOptions? value)
	{
		Instance.Regex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Regex()
	{
		Instance.Regex = Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A regex query that expresses a prefix as a regular expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Regex(System.Action<Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor>? action)
	{
		Instance.Regex = Elastic.Clients.Elasticsearch.Core.Search.RegexOptionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum corrections to be returned per suggest text token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether duplicate suggestions should be filtered out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor SkipDuplicates(bool? value = true)
	{
		Instance.SkipDuplicates = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggesterDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.CompletionSuggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}