// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.BoundaryScannerConverter))]
public enum BoundaryScanner
{
	/// <summary>
	/// <para>
	/// Use the characters specified by <c>boundary_chars</c> as highlighting boundaries.
	/// The <c>boundary_max_scan</c> setting controls how far to scan for boundary characters.
	/// Only valid for the <c>fvh</c> highlighter.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "chars")]
	Chars,
	/// <summary>
	/// <para>
	/// Break highlighted fragments at the next sentence boundary, as determined by Java’s <c>BreakIterator</c>.
	/// You can specify the locale to use with <c>boundary_scanner_locale</c>.
	/// When used with the <c>unified</c> highlighter, the <c>sentence</c> scanner splits sentences bigger than <c>fragment_size</c> at the first word boundary next to fragment_size.
	/// You can set <c>fragment_size</c> to <c>0</c> to never split any sentence.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "sentence")]
	Sentence,
	/// <summary>
	/// <para>
	/// Break highlighted fragments at the next word boundary, as determined by Java’s <c>BreakIterator</c>.
	/// You can specify the locale to use with <c>boundary_scanner_locale</c>.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "word")]
	Word
}