// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class BoundaryScannerConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner>
{
	private static readonly System.Text.Json.JsonEncodedText MemberChars = System.Text.Json.JsonEncodedText.Encode("chars");
	private static readonly System.Text.Json.JsonEncodedText MemberSentence = System.Text.Json.JsonEncodedText.Encode("sentence");
	private static readonly System.Text.Json.JsonEncodedText MemberWord = System.Text.Json.JsonEncodedText.Encode("word");

	public override Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberChars))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Chars;
		}

		if (reader.ValueTextEquals(MemberSentence))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Sentence;
		}

		if (reader.ValueTextEquals(MemberWord))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Word;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberChars.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Chars;
		}

		if (string.Equals(value, MemberSentence.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Sentence;
		}

		if (string.Equals(value, MemberWord.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Word;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Chars:
				writer.WriteStringValue(MemberChars);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Sentence:
				writer.WriteStringValue(MemberSentence);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner.Word:
				writer.WriteStringValue(MemberWord);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.BoundaryScanner value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}