// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class AggregationProfileDebugConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDebug>
{
	private static readonly System.Text.Json.JsonEncodedText PropBruteForceUsed = System.Text.Json.JsonEncodedText.Encode("brute_force_used");
	private static readonly System.Text.Json.JsonEncodedText PropBuiltBuckets = System.Text.Json.JsonEncodedText.Encode("built_buckets");
	private static readonly System.Text.Json.JsonEncodedText PropCharsFetched = System.Text.Json.JsonEncodedText.Encode("chars_fetched");
	private static readonly System.Text.Json.JsonEncodedText PropCollectAnalyzedCount = System.Text.Json.JsonEncodedText.Encode("collect_analyzed_count");
	private static readonly System.Text.Json.JsonEncodedText PropCollectAnalyzedNs = System.Text.Json.JsonEncodedText.Encode("collect_analyzed_ns");
	private static readonly System.Text.Json.JsonEncodedText PropCollectionStrategy = System.Text.Json.JsonEncodedText.Encode("collection_strategy");
	private static readonly System.Text.Json.JsonEncodedText PropDeferredAggregators = System.Text.Json.JsonEncodedText.Encode("deferred_aggregators");
	private static readonly System.Text.Json.JsonEncodedText PropDelegate = System.Text.Json.JsonEncodedText.Encode("delegate");
	private static readonly System.Text.Json.JsonEncodedText PropDelegateDebug = System.Text.Json.JsonEncodedText.Encode("delegate_debug");
	private static readonly System.Text.Json.JsonEncodedText PropDynamicPruningAttempted = System.Text.Json.JsonEncodedText.Encode("dynamic_pruning_attempted");
	private static readonly System.Text.Json.JsonEncodedText PropDynamicPruningUsed = System.Text.Json.JsonEncodedText.Encode("dynamic_pruning_used");
	private static readonly System.Text.Json.JsonEncodedText PropEmptyCollectorsUsed = System.Text.Json.JsonEncodedText.Encode("empty_collectors_used");
	private static readonly System.Text.Json.JsonEncodedText PropExtractCount = System.Text.Json.JsonEncodedText.Encode("extract_count");
	private static readonly System.Text.Json.JsonEncodedText PropExtractNs = System.Text.Json.JsonEncodedText.Encode("extract_ns");
	private static readonly System.Text.Json.JsonEncodedText PropFilters = System.Text.Json.JsonEncodedText.Encode("filters");
	private static readonly System.Text.Json.JsonEncodedText PropHasFilter = System.Text.Json.JsonEncodedText.Encode("has_filter");
	private static readonly System.Text.Json.JsonEncodedText PropMapReducer = System.Text.Json.JsonEncodedText.Encode("map_reducer");
	private static readonly System.Text.Json.JsonEncodedText PropNumericCollectorsUsed = System.Text.Json.JsonEncodedText.Encode("numeric_collectors_used");
	private static readonly System.Text.Json.JsonEncodedText PropOrdinalsCollectorsOverheadTooHigh = System.Text.Json.JsonEncodedText.Encode("ordinals_collectors_overhead_too_high");
	private static readonly System.Text.Json.JsonEncodedText PropOrdinalsCollectorsUsed = System.Text.Json.JsonEncodedText.Encode("ordinals_collectors_used");
	private static readonly System.Text.Json.JsonEncodedText PropResultStrategy = System.Text.Json.JsonEncodedText.Encode("result_strategy");
	private static readonly System.Text.Json.JsonEncodedText PropSegmentsCollected = System.Text.Json.JsonEncodedText.Encode("segments_collected");
	private static readonly System.Text.Json.JsonEncodedText PropSegmentsCounted = System.Text.Json.JsonEncodedText.Encode("segments_counted");
	private static readonly System.Text.Json.JsonEncodedText PropSegmentsWithDeletedDocs = System.Text.Json.JsonEncodedText.Encode("segments_with_deleted_docs");
	private static readonly System.Text.Json.JsonEncodedText PropSegmentsWithDocCountField = System.Text.Json.JsonEncodedText.Encode("segments_with_doc_count_field");
	private static readonly System.Text.Json.JsonEncodedText PropSegmentsWithMultiValuedOrds = System.Text.Json.JsonEncodedText.Encode("segments_with_multi_valued_ords");
	private static readonly System.Text.Json.JsonEncodedText PropSegmentsWithSingleValuedOrds = System.Text.Json.JsonEncodedText.Encode("segments_with_single_valued_ords");
	private static readonly System.Text.Json.JsonEncodedText PropSkippedDueToNoData = System.Text.Json.JsonEncodedText.Encode("skipped_due_to_no_data");
	private static readonly System.Text.Json.JsonEncodedText PropStringHashingCollectorsUsed = System.Text.Json.JsonEncodedText.Encode("string_hashing_collectors_used");
	private static readonly System.Text.Json.JsonEncodedText PropSurvivingBuckets = System.Text.Json.JsonEncodedText.Encode("surviving_buckets");
	private static readonly System.Text.Json.JsonEncodedText PropTotalBuckets = System.Text.Json.JsonEncodedText.Encode("total_buckets");
	private static readonly System.Text.Json.JsonEncodedText PropValuesFetched = System.Text.Json.JsonEncodedText.Encode("values_fetched");

	public override Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDebug Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int?> propBruteForceUsed = default;
		LocalJsonValue<int?> propBuiltBuckets = default;
		LocalJsonValue<int?> propCharsFetched = default;
		LocalJsonValue<int?> propCollectAnalyzedCount = default;
		LocalJsonValue<int?> propCollectAnalyzedNs = default;
		LocalJsonValue<string?> propCollectionStrategy = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>?> propDeferredAggregators = default;
		LocalJsonValue<string?> propDelegate = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDebug?> propDelegateDebug = default;
		LocalJsonValue<int?> propDynamicPruningAttempted = default;
		LocalJsonValue<int?> propDynamicPruningUsed = default;
		LocalJsonValue<int?> propEmptyCollectorsUsed = default;
		LocalJsonValue<int?> propExtractCount = default;
		LocalJsonValue<int?> propExtractNs = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDelegateDebugFilter>?> propFilters = default;
		LocalJsonValue<bool?> propHasFilter = default;
		LocalJsonValue<string?> propMapReducer = default;
		LocalJsonValue<int?> propNumericCollectorsUsed = default;
		LocalJsonValue<int?> propOrdinalsCollectorsOverheadTooHigh = default;
		LocalJsonValue<int?> propOrdinalsCollectorsUsed = default;
		LocalJsonValue<string?> propResultStrategy = default;
		LocalJsonValue<int?> propSegmentsCollected = default;
		LocalJsonValue<int?> propSegmentsCounted = default;
		LocalJsonValue<int?> propSegmentsWithDeletedDocs = default;
		LocalJsonValue<int?> propSegmentsWithDocCountField = default;
		LocalJsonValue<int?> propSegmentsWithMultiValuedOrds = default;
		LocalJsonValue<int?> propSegmentsWithSingleValuedOrds = default;
		LocalJsonValue<int?> propSkippedDueToNoData = default;
		LocalJsonValue<int?> propStringHashingCollectorsUsed = default;
		LocalJsonValue<int?> propSurvivingBuckets = default;
		LocalJsonValue<int?> propTotalBuckets = default;
		LocalJsonValue<int?> propValuesFetched = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBruteForceUsed.TryReadProperty(ref reader, options, PropBruteForceUsed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propBuiltBuckets.TryReadProperty(ref reader, options, PropBuiltBuckets, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propCharsFetched.TryReadProperty(ref reader, options, PropCharsFetched, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propCollectAnalyzedCount.TryReadProperty(ref reader, options, PropCollectAnalyzedCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propCollectAnalyzedNs.TryReadProperty(ref reader, options, PropCollectAnalyzedNs, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propCollectionStrategy.TryReadProperty(ref reader, options, PropCollectionStrategy, null))
			{
				continue;
			}

			if (propDeferredAggregators.TryReadProperty(ref reader, options, PropDeferredAggregators, static System.Collections.Generic.IReadOnlyCollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propDelegate.TryReadProperty(ref reader, options, PropDelegate, null))
			{
				continue;
			}

			if (propDelegateDebug.TryReadProperty(ref reader, options, PropDelegateDebug, null))
			{
				continue;
			}

			if (propDynamicPruningAttempted.TryReadProperty(ref reader, options, PropDynamicPruningAttempted, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propDynamicPruningUsed.TryReadProperty(ref reader, options, PropDynamicPruningUsed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propEmptyCollectorsUsed.TryReadProperty(ref reader, options, PropEmptyCollectorsUsed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propExtractCount.TryReadProperty(ref reader, options, PropExtractCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propExtractNs.TryReadProperty(ref reader, options, PropExtractNs, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propFilters.TryReadProperty(ref reader, options, PropFilters, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDelegateDebugFilter>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDelegateDebugFilter>(o, null)))
			{
				continue;
			}

			if (propHasFilter.TryReadProperty(ref reader, options, PropHasFilter, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propMapReducer.TryReadProperty(ref reader, options, PropMapReducer, null))
			{
				continue;
			}

			if (propNumericCollectorsUsed.TryReadProperty(ref reader, options, PropNumericCollectorsUsed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propOrdinalsCollectorsOverheadTooHigh.TryReadProperty(ref reader, options, PropOrdinalsCollectorsOverheadTooHigh, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propOrdinalsCollectorsUsed.TryReadProperty(ref reader, options, PropOrdinalsCollectorsUsed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propResultStrategy.TryReadProperty(ref reader, options, PropResultStrategy, null))
			{
				continue;
			}

			if (propSegmentsCollected.TryReadProperty(ref reader, options, PropSegmentsCollected, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSegmentsCounted.TryReadProperty(ref reader, options, PropSegmentsCounted, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSegmentsWithDeletedDocs.TryReadProperty(ref reader, options, PropSegmentsWithDeletedDocs, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSegmentsWithDocCountField.TryReadProperty(ref reader, options, PropSegmentsWithDocCountField, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSegmentsWithMultiValuedOrds.TryReadProperty(ref reader, options, PropSegmentsWithMultiValuedOrds, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSegmentsWithSingleValuedOrds.TryReadProperty(ref reader, options, PropSegmentsWithSingleValuedOrds, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSkippedDueToNoData.TryReadProperty(ref reader, options, PropSkippedDueToNoData, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propStringHashingCollectorsUsed.TryReadProperty(ref reader, options, PropStringHashingCollectorsUsed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSurvivingBuckets.TryReadProperty(ref reader, options, PropSurvivingBuckets, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTotalBuckets.TryReadProperty(ref reader, options, PropTotalBuckets, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propValuesFetched.TryReadProperty(ref reader, options, PropValuesFetched, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDebug(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BruteForceUsed = propBruteForceUsed.Value,
			BuiltBuckets = propBuiltBuckets.Value,
			CharsFetched = propCharsFetched.Value,
			CollectAnalyzedCount = propCollectAnalyzedCount.Value,
			CollectAnalyzedNs = propCollectAnalyzedNs.Value,
			CollectionStrategy = propCollectionStrategy.Value,
			DeferredAggregators = propDeferredAggregators.Value,
			Delegate = propDelegate.Value,
			DelegateDebug = propDelegateDebug.Value,
			DynamicPruningAttempted = propDynamicPruningAttempted.Value,
			DynamicPruningUsed = propDynamicPruningUsed.Value,
			EmptyCollectorsUsed = propEmptyCollectorsUsed.Value,
			ExtractCount = propExtractCount.Value,
			ExtractNs = propExtractNs.Value,
			Filters = propFilters.Value,
			HasFilter = propHasFilter.Value,
			MapReducer = propMapReducer.Value,
			NumericCollectorsUsed = propNumericCollectorsUsed.Value,
			OrdinalsCollectorsOverheadTooHigh = propOrdinalsCollectorsOverheadTooHigh.Value,
			OrdinalsCollectorsUsed = propOrdinalsCollectorsUsed.Value,
			ResultStrategy = propResultStrategy.Value,
			SegmentsCollected = propSegmentsCollected.Value,
			SegmentsCounted = propSegmentsCounted.Value,
			SegmentsWithDeletedDocs = propSegmentsWithDeletedDocs.Value,
			SegmentsWithDocCountField = propSegmentsWithDocCountField.Value,
			SegmentsWithMultiValuedOrds = propSegmentsWithMultiValuedOrds.Value,
			SegmentsWithSingleValuedOrds = propSegmentsWithSingleValuedOrds.Value,
			SkippedDueToNoData = propSkippedDueToNoData.Value,
			StringHashingCollectorsUsed = propStringHashingCollectorsUsed.Value,
			SurvivingBuckets = propSurvivingBuckets.Value,
			TotalBuckets = propTotalBuckets.Value,
			ValuesFetched = propValuesFetched.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDebug value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBruteForceUsed, value.BruteForceUsed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropBuiltBuckets, value.BuiltBuckets, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropCharsFetched, value.CharsFetched, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropCollectAnalyzedCount, value.CollectAnalyzedCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropCollectAnalyzedNs, value.CollectAnalyzedNs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropCollectionStrategy, value.CollectionStrategy, null, null);
		writer.WriteProperty(options, PropDeferredAggregators, value.DeferredAggregators, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropDelegate, value.Delegate, null, null);
		writer.WriteProperty(options, PropDelegateDebug, value.DelegateDebug, null, null);
		writer.WriteProperty(options, PropDynamicPruningAttempted, value.DynamicPruningAttempted, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropDynamicPruningUsed, value.DynamicPruningUsed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropEmptyCollectorsUsed, value.EmptyCollectorsUsed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropExtractCount, value.ExtractCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropExtractNs, value.ExtractNs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropFilters, value.Filters, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDelegateDebugFilter>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Core.Search.AggregationProfileDelegateDebugFilter>(o, v, null));
		writer.WriteProperty(options, PropHasFilter, value.HasFilter, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropMapReducer, value.MapReducer, null, null);
		writer.WriteProperty(options, PropNumericCollectorsUsed, value.NumericCollectorsUsed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropOrdinalsCollectorsOverheadTooHigh, value.OrdinalsCollectorsOverheadTooHigh, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropOrdinalsCollectorsUsed, value.OrdinalsCollectorsUsed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropResultStrategy, value.ResultStrategy, null, null);
		writer.WriteProperty(options, PropSegmentsCollected, value.SegmentsCollected, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSegmentsCounted, value.SegmentsCounted, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSegmentsWithDeletedDocs, value.SegmentsWithDeletedDocs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSegmentsWithDocCountField, value.SegmentsWithDocCountField, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSegmentsWithMultiValuedOrds, value.SegmentsWithMultiValuedOrds, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSegmentsWithSingleValuedOrds, value.SegmentsWithSingleValuedOrds, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSkippedDueToNoData, value.SkippedDueToNoData, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropStringHashingCollectorsUsed, value.StringHashingCollectorsUsed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSurvivingBuckets, value.SurvivingBuckets, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTotalBuckets, value.TotalBuckets, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropValuesFetched, value.ValuesFetched, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteEndObject();
	}
}