// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.Json.PainlessContextSetupConverter))]
public sealed partial class PainlessContextSetup
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PainlessContextSetup(object document, Elastic.Clients.Elasticsearch.IndexName index)
	{
		Document = document;
		Index = index;
	}
#if NET7_0_OR_GREATER
	public PainlessContextSetup()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PainlessContextSetup()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PainlessContextSetup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Document that's temporarily indexed in-memory and accessible from the script.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object Document { get; set; }

	/// <summary>
	/// <para>
	/// Index containing a mapping that's compatible with the indexed document.
	/// You may specify a remote index by prefixing the index with the remote cluster alias.
	/// For example, <c>remote1:my_index</c> indicates that you want to run the painless script against the "my_index" index on the "remote1" cluster.
	/// This request will be forwarded to the "remote1" cluster if you have configured a connection to that remote cluster.
	/// </para>
	/// <para>
	/// NOTE: Wildcards are not accepted in the index expression for this endpoint.
	/// The expression <c>*:myindex</c> will return the error "No such remote cluster" and the expression <c>logs*</c> or <c>remote1:logs*</c> will return the error "index not found".
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get; set; }

	/// <summary>
	/// <para>
	/// Use this parameter to specify a query for computing a score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }
}

public readonly partial struct PainlessContextSetupDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PainlessContextSetupDescriptor(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PainlessContextSetupDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup instance) => new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Document that's temporarily indexed in-memory and accessible from the script.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument> Document(object value)
	{
		Instance.Document = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Index containing a mapping that's compatible with the indexed document.
	/// You may specify a remote index by prefixing the index with the remote cluster alias.
	/// For example, <c>remote1:my_index</c> indicates that you want to run the painless script against the "my_index" index on the "remote1" cluster.
	/// This request will be forwarded to the "remote1" cluster if you have configured a connection to that remote cluster.
	/// </para>
	/// <para>
	/// NOTE: Wildcards are not accepted in the index expression for this endpoint.
	/// The expression <c>*:myindex</c> will return the error "No such remote cluster" and the expression <c>logs*</c> or <c>remote1:logs*</c> will return the error "index not found".
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use this parameter to specify a query for computing a score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use this parameter to specify a query for computing a score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup Build(System.Action<Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PainlessContextSetupDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PainlessContextSetupDescriptor(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PainlessContextSetupDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup instance) => new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Document that's temporarily indexed in-memory and accessible from the script.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor Document(object value)
	{
		Instance.Document = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Index containing a mapping that's compatible with the indexed document.
	/// You may specify a remote index by prefixing the index with the remote cluster alias.
	/// For example, <c>remote1:my_index</c> indicates that you want to run the painless script against the "my_index" index on the "remote1" cluster.
	/// This request will be forwarded to the "remote1" cluster if you have configured a connection to that remote cluster.
	/// </para>
	/// <para>
	/// NOTE: Wildcards are not accepted in the index expression for this endpoint.
	/// The expression <c>*:myindex</c> will return the error "No such remote cluster" and the expression <c>logs*</c> or <c>remote1:logs*</c> will return the error "index not found".
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use this parameter to specify a query for computing a score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use this parameter to specify a query for computing a score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use this parameter to specify a query for computing a score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup Build(System.Action<Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor(new Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}