// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.ReindexRethrottle;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.ReindexRethrottle.Json.ReindexStatusConverter))]
public sealed partial class ReindexStatus
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReindexStatus(long batches, long created, long deleted, long noops, float requestsPerSecond, Elastic.Clients.Elasticsearch.Retries retries, System.TimeSpan throttledMillis, System.TimeSpan throttledUntilMillis, long total, long updated, long versionConflicts)
	{
		Batches = batches;
		Created = created;
		Deleted = deleted;
		Noops = noops;
		RequestsPerSecond = requestsPerSecond;
		Retries = retries;
		ThrottledMillis = throttledMillis;
		ThrottledUntilMillis = throttledUntilMillis;
		Total = total;
		Updated = updated;
		VersionConflicts = versionConflicts;
	}
#if NET7_0_OR_GREATER
	public ReindexStatus()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ReindexStatus()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReindexStatus(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of scroll responses pulled back by the reindex.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Batches { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully created.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Created { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully deleted.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Deleted { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were ignored because the script used for the reindex returned a <c>noop</c> value for <c>ctx.op</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Noops { get; set; }

	/// <summary>
	/// <para>
	/// The number of requests per second effectively executed during the reindex.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	float RequestsPerSecond { get; set; }

	/// <summary>
	/// <para>
	/// The number of retries attempted by reindex. <c>bulk</c> is the number of bulk actions retried and <c>search</c> is the number of search actions retried.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Retries Retries { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? Throttled { get; set; }

	/// <summary>
	/// <para>
	/// Number of milliseconds the request slept to conform to <c>requests_per_second</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ThrottledMillis { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? ThrottledUntil { get; set; }

	/// <summary>
	/// <para>
	/// This field should always be equal to zero in a <c>_reindex</c> response.
	/// It only has meaning when using the Task API, where it indicates the next time (in milliseconds since epoch) a throttled request will be executed again in order to conform to <c>requests_per_second</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ThrottledUntilMillis { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully processed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Total { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully updated, for example, a document with same ID already existed prior to reindex updating it.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Updated { get; set; }

	/// <summary>
	/// <para>
	/// The number of version conflicts that reindex hits.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long VersionConflicts { get; set; }
}