// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.ReindexRethrottle.Json;

public sealed partial class ReindexStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.ReindexRethrottle.ReindexStatus>
{
	private static readonly System.Text.Json.JsonEncodedText PropBatches = System.Text.Json.JsonEncodedText.Encode("batches");
	private static readonly System.Text.Json.JsonEncodedText PropCreated = System.Text.Json.JsonEncodedText.Encode("created");
	private static readonly System.Text.Json.JsonEncodedText PropDeleted = System.Text.Json.JsonEncodedText.Encode("deleted");
	private static readonly System.Text.Json.JsonEncodedText PropNoops = System.Text.Json.JsonEncodedText.Encode("noops");
	private static readonly System.Text.Json.JsonEncodedText PropRequestsPerSecond = System.Text.Json.JsonEncodedText.Encode("requests_per_second");
	private static readonly System.Text.Json.JsonEncodedText PropRetries = System.Text.Json.JsonEncodedText.Encode("retries");
	private static readonly System.Text.Json.JsonEncodedText PropThrottled = System.Text.Json.JsonEncodedText.Encode("throttled");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledMillis = System.Text.Json.JsonEncodedText.Encode("throttled_millis");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledUntil = System.Text.Json.JsonEncodedText.Encode("throttled_until");
	private static readonly System.Text.Json.JsonEncodedText PropThrottledUntilMillis = System.Text.Json.JsonEncodedText.Encode("throttled_until_millis");
	private static readonly System.Text.Json.JsonEncodedText PropTotal = System.Text.Json.JsonEncodedText.Encode("total");
	private static readonly System.Text.Json.JsonEncodedText PropUpdated = System.Text.Json.JsonEncodedText.Encode("updated");
	private static readonly System.Text.Json.JsonEncodedText PropVersionConflicts = System.Text.Json.JsonEncodedText.Encode("version_conflicts");

	public override Elastic.Clients.Elasticsearch.Core.ReindexRethrottle.ReindexStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propBatches = default;
		LocalJsonValue<long> propCreated = default;
		LocalJsonValue<long> propDeleted = default;
		LocalJsonValue<long> propNoops = default;
		LocalJsonValue<float> propRequestsPerSecond = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Retries> propRetries = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propThrottled = default;
		LocalJsonValue<System.TimeSpan> propThrottledMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propThrottledUntil = default;
		LocalJsonValue<System.TimeSpan> propThrottledUntilMillis = default;
		LocalJsonValue<long> propTotal = default;
		LocalJsonValue<long> propUpdated = default;
		LocalJsonValue<long> propVersionConflicts = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBatches.TryReadProperty(ref reader, options, PropBatches, null))
			{
				continue;
			}

			if (propCreated.TryReadProperty(ref reader, options, PropCreated, null))
			{
				continue;
			}

			if (propDeleted.TryReadProperty(ref reader, options, PropDeleted, null))
			{
				continue;
			}

			if (propNoops.TryReadProperty(ref reader, options, PropNoops, null))
			{
				continue;
			}

			if (propRequestsPerSecond.TryReadProperty(ref reader, options, PropRequestsPerSecond, null))
			{
				continue;
			}

			if (propRetries.TryReadProperty(ref reader, options, PropRetries, null))
			{
				continue;
			}

			if (propThrottled.TryReadProperty(ref reader, options, PropThrottled, null))
			{
				continue;
			}

			if (propThrottledMillis.TryReadProperty(ref reader, options, PropThrottledMillis, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propThrottledUntil.TryReadProperty(ref reader, options, PropThrottledUntil, null))
			{
				continue;
			}

			if (propThrottledUntilMillis.TryReadProperty(ref reader, options, PropThrottledUntilMillis, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propTotal.TryReadProperty(ref reader, options, PropTotal, null))
			{
				continue;
			}

			if (propUpdated.TryReadProperty(ref reader, options, PropUpdated, null))
			{
				continue;
			}

			if (propVersionConflicts.TryReadProperty(ref reader, options, PropVersionConflicts, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.ReindexRethrottle.ReindexStatus(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Batches = propBatches.Value,
			Created = propCreated.Value,
			Deleted = propDeleted.Value,
			Noops = propNoops.Value,
			RequestsPerSecond = propRequestsPerSecond.Value,
			Retries = propRetries.Value,
			Throttled = propThrottled.Value,
			ThrottledMillis = propThrottledMillis.Value,
			ThrottledUntil = propThrottledUntil.Value,
			ThrottledUntilMillis = propThrottledUntilMillis.Value,
			Total = propTotal.Value,
			Updated = propUpdated.Value,
			VersionConflicts = propVersionConflicts.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.ReindexRethrottle.ReindexStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBatches, value.Batches, null, null);
		writer.WriteProperty(options, PropCreated, value.Created, null, null);
		writer.WriteProperty(options, PropDeleted, value.Deleted, null, null);
		writer.WriteProperty(options, PropNoops, value.Noops, null, null);
		writer.WriteProperty(options, PropRequestsPerSecond, value.RequestsPerSecond, null, null);
		writer.WriteProperty(options, PropRetries, value.Retries, null, null);
		writer.WriteProperty(options, PropThrottled, value.Throttled, null, null);
		writer.WriteProperty(options, PropThrottledMillis, value.ThrottledMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropThrottledUntil, value.ThrottledUntil, null, null);
		writer.WriteProperty(options, PropThrottledUntilMillis, value.ThrottledUntilMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropTotal, value.Total, null, null);
		writer.WriteProperty(options, PropUpdated, value.Updated, null, null);
		writer.WriteProperty(options, PropVersionConflicts, value.VersionConflicts, null, null);
		writer.WriteEndObject();
	}
}