// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Reindex;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Reindex.Json.SourceConverter))]
public sealed partial class Source
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Source(Elastic.Clients.Elasticsearch.Indices indices)
	{
		Indices = indices;
	}
#if NET7_0_OR_GREATER
	public Source()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Source()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the data stream, index, or alias you are copying from.
	/// It accepts a comma-separated list to reindex from multiple sources.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get; set; }

	/// <summary>
	/// <para>
	/// The documents to reindex, which is defined with Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }

	/// <summary>
	/// <para>
	/// A remote instance of Elasticsearch that you want to index from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource? Remote { get; set; }
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents to index per batch.
	/// Use it when you are indexing from remote to ensure that the batches fit within the on-heap buffer, which defaults to a maximum size of 100 MB.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// Slice the reindex request manually using the provided slice ID and total number of slices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SlicedScroll? Slice { get; set; }

	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	[System.Obsolete("Deprecated in '7.6.0'.")]
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, reindex all source fields.
	/// Set it to a list to reindex select fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceFields { get; set; }
}

public readonly partial struct SourceDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Reindex.Source Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.Source instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Reindex.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Reindex.Source instance) => new Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Reindex.Source(Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the data stream, index, or alias you are copying from.
	/// It accepts a comma-separated list to reindex from multiple sources.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The documents to reindex, which is defined with Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The documents to reindex, which is defined with Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A remote instance of Elasticsearch that you want to index from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Remote(Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource? value)
	{
		Instance.Remote = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A remote instance of Elasticsearch that you want to index from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Remote(System.Action<Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor> action)
	{
		Instance.Remote = Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of documents to index per batch.
	/// Use it when you are indexing from remote to ensure that the batches fit within the on-heap buffer, which defaults to a maximum size of 100 MB.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Slice the reindex request manually using the provided slice ID and total number of slices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Slice the reindex request manually using the provided slice ID and total number of slices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, reindex all source fields.
	/// Set it to a list to reindex select fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> SourceFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, reindex all source fields.
	/// Set it to a list to reindex select fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument> SourceFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceFields = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Reindex.Source Build(System.Action<Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Reindex.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SourceDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Reindex.Source Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.Source instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SourceDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Reindex.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.Source instance) => new Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Reindex.Source(Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the data stream, index, or alias you are copying from.
	/// It accepts a comma-separated list to reindex from multiple sources.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The documents to reindex, which is defined with Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The documents to reindex, which is defined with Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The documents to reindex, which is defined with Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A remote instance of Elasticsearch that you want to index from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Remote(Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource? value)
	{
		Instance.Remote = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A remote instance of Elasticsearch that you want to index from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Remote(System.Action<Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor> action)
	{
		Instance.Remote = Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of documents to index per batch.
	/// Use it when you are indexing from remote to ensure that the batches fit within the on-heap buffer, which defaults to a maximum size of 100 MB.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Slice the reindex request manually using the provided slice ID and total number of slices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Slice the reindex request manually using the provided slice ID and total number of slices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Slice the reindex request manually using the provided slice ID and total number of slices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Slice<T>(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>.Build(action);
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Obsolete("Deprecated in '7.6.0'.")]
	/// <summary>
	/// <para>
	/// A comma-separated list of <c>&lt;field>:&lt;direction></c> pairs to sort by before indexing.
	/// Use it in conjunction with <c>max_docs</c> to control what documents are reindexed.
	/// </para>
	/// <para>
	/// WARNING: Sort in reindex is deprecated.
	/// Sorting in reindex was never guaranteed to index documents in order and prevents further development of reindex such as resilience and performance improvements.
	/// If used in combination with <c>max_docs</c>, consider using a query filter instead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, reindex all source fields.
	/// Set it to a list to reindex select fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor SourceFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, reindex all source fields.
	/// Set it to a list to reindex select fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor SourceFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceFields = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Reindex.Source Build(System.Action<Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Reindex.SourceDescriptor(new Elastic.Clients.Elasticsearch.Core.Reindex.Source(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}