// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Reindex;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Reindex.Json.RemoteSourceConverter))]
public sealed partial class RemoteSource
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteSource(string host)
	{
		Host = host;
	}
#if NET7_0_OR_GREATER
	public RemoteSource()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RemoteSource()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RemoteSource(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The remote connection timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? ConnectTimeout { get; set; }

	/// <summary>
	/// <para>
	/// An object containing the headers of the request.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, string>? Headers { get; set; }

	/// <summary>
	/// <para>
	/// The URL for the remote instance of Elasticsearch that you want to index from.
	/// This information is required when you're indexing from remote.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Host { get; set; }

	/// <summary>
	/// <para>
	/// The password to use for authentication with the remote host.
	/// </para>
	/// </summary>
	public string? Password { get; set; }

	/// <summary>
	/// <para>
	/// The remote socket read timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? SocketTimeout { get; set; }

	/// <summary>
	/// <para>
	/// The username to use for authentication with the remote host.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Username? Username { get; set; }
}

public readonly partial struct RemoteSourceDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteSourceDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteSourceDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource instance) => new Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource(Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The remote connection timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor ConnectTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ConnectTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object containing the headers of the request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor Headers(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.Headers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object containing the headers of the request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor Headers()
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// An object containing the headers of the request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor Headers(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor AddHeader(string key, string value)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.Headers.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The URL for the remote instance of Elasticsearch that you want to index from.
	/// This information is required when you're indexing from remote.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor Host(string value)
	{
		Instance.Host = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The password to use for authentication with the remote host.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor Password(string? value)
	{
		Instance.Password = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The remote socket read timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor SocketTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.SocketTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The username to use for authentication with the remote host.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor Username(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource Build(System.Action<Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSourceDescriptor(new Elastic.Clients.Elasticsearch.Core.Reindex.RemoteSource(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}