// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Reindex;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Reindex.Json.DestinationConverter))]
public sealed partial class Destination
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Destination(Elastic.Clients.Elasticsearch.IndexName index)
	{
		Index = index;
	}
#if NET7_0_OR_GREATER
	public Destination()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Destination()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Destination(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the data stream, index, or index alias you are copying to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get; set; }

	/// <summary>
	/// <para>
	/// If it is <c>create</c>, the operation will only index documents that do not already exist (also known as "put if absent").
	/// </para>
	/// <para>
	/// IMPORTANT: To reindex to a data stream destination, this argument must be <c>create</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.OpType? OpType { get; set; }

	/// <summary>
	/// <para>
	/// The name of the pipeline to use.
	/// </para>
	/// </summary>
	public string? Pipeline { get; set; }

	/// <summary>
	/// <para>
	/// By default, a document's routing is preserved unless it's changed by the script.
	/// If it is <c>keep</c>, the routing on the bulk request sent for each match is set to the routing on the match.
	/// If it is <c>discard</c>, the routing on the bulk request sent for each match is set to <c>null</c>.
	/// If it is <c>=value</c>, the routing on the bulk request sent for each match is set to all value specified after the equals sign (<c>=</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }

	/// <summary>
	/// <para>
	/// The versioning to use for the indexing operation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.VersionType? VersionType { get; set; }
}

public readonly partial struct DestinationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Reindex.Destination Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DestinationDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.Destination instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DestinationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Reindex.Destination(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor(Elastic.Clients.Elasticsearch.Core.Reindex.Destination instance) => new Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Reindex.Destination(Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the data stream, index, or index alias you are copying to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If it is <c>create</c>, the operation will only index documents that do not already exist (also known as "put if absent").
	/// </para>
	/// <para>
	/// IMPORTANT: To reindex to a data stream destination, this argument must be <c>create</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor OpType(Elastic.Clients.Elasticsearch.OpType? value)
	{
		Instance.OpType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the pipeline to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor Pipeline(string? value)
	{
		Instance.Pipeline = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// By default, a document's routing is preserved unless it's changed by the script.
	/// If it is <c>keep</c>, the routing on the bulk request sent for each match is set to the routing on the match.
	/// If it is <c>discard</c>, the routing on the bulk request sent for each match is set to <c>null</c>.
	/// If it is <c>=value</c>, the routing on the bulk request sent for each match is set to all value specified after the equals sign (<c>=</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The versioning to use for the indexing operation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Reindex.Destination Build(System.Action<Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Reindex.DestinationDescriptor(new Elastic.Clients.Elasticsearch.Core.Reindex.Destination(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}