// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.RankEval;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.RankEval.Json.RankEvalRequestItemConverter))]
public sealed partial class RankEvalRequestItem
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestItem(Elastic.Clients.Elasticsearch.Id id, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating> ratings)
	{
		Id = id;
		Ratings = ratings;
	}
#if NET7_0_OR_GREATER
	public RankEvalRequestItem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RankEvalRequestItem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankEvalRequestItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The search request’s ID, used to group result details later.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get; set; }

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Params { get; set; }

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating> Ratings { get; set; }

	/// <summary>
	/// <para>
	/// The query being evaluated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQuery? Request { get; set; }

	/// <summary>
	/// <para>
	/// The search template Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? TemplateId { get; set; }
}

public readonly partial struct RankEvalRequestItemDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestItemDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestItemDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem instance) => new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The search request’s ID, used to group result details later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Ratings(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating> value)
	{
		Instance.Ratings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Ratings(params Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating[] values)
	{
		Instance.Ratings = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Ratings(params System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor.Build(action));
		}

		Instance.Ratings = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query being evaluated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Request(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQuery? value)
	{
		Instance.Request = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query being evaluated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> Request(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQueryDescriptor<TDocument>> action)
	{
		Instance.Request = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument> TemplateId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.TemplateId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem Build(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RankEvalRequestItemDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestItemDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestItemDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem instance) => new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The search request’s ID, used to group result details later.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Params(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Params()
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Params(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Params = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor AddParam(string key, object value)
	{
		Instance.Params ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Params.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Ratings(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating> value)
	{
		Instance.Ratings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Ratings(params Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating[] values)
	{
		Instance.Ratings = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// List of document ratings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Ratings(params System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor.Build(action));
		}

		Instance.Ratings = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query being evaluated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Request(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQuery? value)
	{
		Instance.Request = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query being evaluated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Request(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQueryDescriptor> action)
	{
		Instance.Request = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The query being evaluated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor Request<T>(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQueryDescriptor<T>> action)
	{
		Instance.Request = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search template Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor TemplateId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.TemplateId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem Build(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor(new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}