// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.RankEval;

/// <summary>
/// <para>
/// Recall at K (R@k)
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-rank-eval#k-recall">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.RankEval.Json.RankEvalMetricRecallConverter))]
public sealed partial class RankEvalMetricRecall
{
#if NET7_0_OR_GREATER
	public RankEvalMetricRecall()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RankEvalMetricRecall()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankEvalMetricRecall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query.
	/// </para>
	/// </summary>
	public int? K { get; set; }

	/// <summary>
	/// <para>
	/// Sets the rating threshold above which documents are considered to be "relevant".
	/// </para>
	/// </summary>
	public int? RelevantRatingThreshold { get; set; }
}

/// <summary>
/// <para>
/// Recall at K (R@k)
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-rank-eval#k-recall">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
public readonly partial struct RankEvalMetricRecallDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricRecallDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricRecallDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall instance) => new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets the rating threshold above which documents are considered to be "relevant".
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor RelevantRatingThreshold(int? value)
	{
		Instance.RelevantRatingThreshold = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall Build(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecallDescriptor(new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}