// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.RankEval;

/// <summary>
/// <para>
/// Precision at K (P@k)
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-rank-eval#k-precision">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.RankEval.Json.RankEvalMetricPrecisionConverter))]
public sealed partial class RankEvalMetricPrecision
{
#if NET7_0_OR_GREATER
	public RankEvalMetricPrecision()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RankEvalMetricPrecision()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankEvalMetricPrecision(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Controls how unlabeled documents in the search results are counted. If set to true, unlabeled documents are ignored and neither count as relevant or irrelevant. Set to false (the default), they are treated as irrelevant.
	/// </para>
	/// </summary>
	public bool? IgnoreUnlabeled { get; set; }

	/// <summary>
	/// <para>
	/// Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query.
	/// </para>
	/// </summary>
	public int? K { get; set; }

	/// <summary>
	/// <para>
	/// Sets the rating threshold above which documents are considered to be "relevant".
	/// </para>
	/// </summary>
	public int? RelevantRatingThreshold { get; set; }
}

/// <summary>
/// <para>
/// Precision at K (P@k)
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-rank-eval#k-precision">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
public readonly partial struct RankEvalMetricPrecisionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricPrecisionDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricPrecisionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision instance) => new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Controls how unlabeled documents in the search results are counted. If set to true, unlabeled documents are ignored and neither count as relevant or irrelevant. Set to false (the default), they are treated as irrelevant.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor IgnoreUnlabeled(bool? value = true)
	{
		Instance.IgnoreUnlabeled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sets the rating threshold above which documents are considered to be "relevant".
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor RelevantRatingThreshold(int? value)
	{
		Instance.RelevantRatingThreshold = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision Build(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecisionDescriptor(new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}