// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.RankEval;

/// <summary>
/// <para>
/// Expected Reciprocal Rank (ERR)
/// </para>
/// <para><see href="https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-rank-eval#_expected_reciprocal_rank_err">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.RankEval.Json.RankEvalMetricExpectedReciprocalRankConverter))]
public sealed partial class RankEvalMetricExpectedReciprocalRank
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricExpectedReciprocalRank(int maximumRelevance)
	{
		MaximumRelevance = maximumRelevance;
	}
#if NET7_0_OR_GREATER
	public RankEvalMetricExpectedReciprocalRank()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RankEvalMetricExpectedReciprocalRank()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankEvalMetricExpectedReciprocalRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query.
	/// </para>
	/// </summary>
	public int? K { get; set; }

	/// <summary>
	/// <para>
	/// The highest relevance grade used in the user-supplied relevance judgments.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MaximumRelevance { get; set; }
}

/// <summary>
/// <para>
/// Expected Reciprocal Rank (ERR)
/// </para>
/// <para><see href="https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-rank-eval#_expected_reciprocal_rank_err">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
public readonly partial struct RankEvalMetricExpectedReciprocalRankDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricExpectedReciprocalRankDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalMetricExpectedReciprocalRankDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank instance) => new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Sets the maximum number of documents retrieved per query. This value will act in place of the usual size parameter in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The highest relevance grade used in the user-supplied relevance judgments.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor MaximumRelevance(int value)
	{
		Instance.MaximumRelevance = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank Build(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRankDescriptor(new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}