// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.RankEval.Json;

public sealed partial class RankEvalMetricConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric>
{
	private static readonly System.Text.Json.JsonEncodedText PropDcg = System.Text.Json.JsonEncodedText.Encode("dcg");
	private static readonly System.Text.Json.JsonEncodedText PropExpectedReciprocalRank = System.Text.Json.JsonEncodedText.Encode("expected_reciprocal_rank");
	private static readonly System.Text.Json.JsonEncodedText PropMeanReciprocalRank = System.Text.Json.JsonEncodedText.Encode("mean_reciprocal_rank");
	private static readonly System.Text.Json.JsonEncodedText PropPrecision = System.Text.Json.JsonEncodedText.Encode("precision");
	private static readonly System.Text.Json.JsonEncodedText PropRecall = System.Text.Json.JsonEncodedText.Encode("recall");

	public override Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDiscountedCumulativeGain?> propDcg = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricExpectedReciprocalRank?> propExpectedReciprocalRank = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricMeanReciprocalRank?> propMeanReciprocalRank = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricPrecision?> propPrecision = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricRecall?> propRecall = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDcg.TryReadProperty(ref reader, options, PropDcg, null))
			{
				continue;
			}

			if (propExpectedReciprocalRank.TryReadProperty(ref reader, options, PropExpectedReciprocalRank, null))
			{
				continue;
			}

			if (propMeanReciprocalRank.TryReadProperty(ref reader, options, PropMeanReciprocalRank, null))
			{
				continue;
			}

			if (propPrecision.TryReadProperty(ref reader, options, PropPrecision, null))
			{
				continue;
			}

			if (propRecall.TryReadProperty(ref reader, options, PropRecall, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Dcg = propDcg.Value,
			ExpectedReciprocalRank = propExpectedReciprocalRank.Value,
			MeanReciprocalRank = propMeanReciprocalRank.Value,
			Precision = propPrecision.Value,
			Recall = propRecall.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDcg, value.Dcg, null, null);
		writer.WriteProperty(options, PropExpectedReciprocalRank, value.ExpectedReciprocalRank, null, null);
		writer.WriteProperty(options, PropMeanReciprocalRank, value.MeanReciprocalRank, null, null);
		writer.WriteProperty(options, PropPrecision, value.Precision, null, null);
		writer.WriteProperty(options, PropRecall, value.Recall, null, null);
		writer.WriteEndObject();
	}
}