// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.RankEval;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.RankEval.Json.DocumentRatingConverter))]
public sealed partial class DocumentRating
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocumentRating(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.IndexName index, int rating)
	{
		Id = id;
		Index = index;
		Rating = rating;
	}
#if NET7_0_OR_GREATER
	public DocumentRating()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DocumentRating()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DocumentRating(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The document ID.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get; set; }

	/// <summary>
	/// <para>
	/// The document’s index. For data streams, this should be the document’s backing index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get; set; }

	/// <summary>
	/// <para>
	/// The document’s relevance with regard to this search request.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Rating { get; set; }
}

public readonly partial struct DocumentRatingDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocumentRatingDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocumentRatingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor(Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating instance) => new Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating(Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The document ID.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document’s index. For data streams, this should be the document’s backing index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The document’s relevance with regard to this search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor Rating(int value)
	{
		Instance.Rating = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating Build(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRatingDescriptor(new Elastic.Clients.Elasticsearch.Core.RankEval.DocumentRating(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}