// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Mtermvectors;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Mtermvectors.Json.MultiTermVectorsOperationConverter))]
public sealed partial class MultiTermVectorsOperation
{
#if NET7_0_OR_GREATER
	public MultiTermVectorsOperation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MultiTermVectorsOperation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// An artificial document (a document not present in the index) for which you want to retrieve term vectors.
	/// </para>
	/// </summary>
	public object? Doc { get; set; }

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// Used as the default list unless a specific field list is provided in the <c>completion_fields</c> or <c>fielddata_fields</c> parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the document count, sum of document frequencies, and sum of total term frequencies.
	/// </para>
	/// </summary>
	public bool? FieldStatistics { get; set; }

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.Filter? Filter { get; set; }

	/// <summary>
	/// <para>
	/// The ID of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get; set; }

	/// <summary>
	/// <para>
	/// The index of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term offsets.
	/// </para>
	/// </summary>
	public bool? Offsets { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term payloads.
	/// </para>
	/// </summary>
	public bool? Payloads { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term positions.
	/// </para>
	/// </summary>
	public bool? Positions { get; set; }

	/// <summary>
	/// <para>
	/// Custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }

	/// <summary>
	/// <para>
	/// If true, the response includes term frequency and document frequency.
	/// </para>
	/// </summary>
	public bool? TermStatistics { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public long? Version { get; set; }

	/// <summary>
	/// <para>
	/// Specific version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.VersionType? VersionType { get; set; }
}

public readonly partial struct MultiTermVectorsOperationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermVectorsOperationDescriptor(Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermVectorsOperationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation instance) => new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An artificial document (a document not present in the index) for which you want to retrieve term vectors.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Doc(object? value)
	{
		Instance.Doc = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// Used as the default list unless a specific field list is provided in the <c>completion_fields</c> or <c>fielddata_fields</c> parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// Used as the default list unless a specific field list is provided in the <c>completion_fields</c> or <c>fielddata_fields</c> parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the document count, sum of document frequencies, and sum of total term frequencies.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> FieldStatistics(bool? value = true)
	{
		Instance.FieldStatistics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.Core.TermVectors.Filter? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Filter()
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor>? action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The index of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term offsets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Offsets(bool? value = true)
	{
		Instance.Offsets = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term payloads.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Payloads(bool? value = true)
	{
		Instance.Payloads = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term positions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Positions(bool? value = true)
	{
		Instance.Positions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the response includes term frequency and document frequency.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> TermStatistics(bool? value = true)
	{
		Instance.TermStatistics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specific version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument> VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation Build(System.Action<Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MultiTermVectorsOperationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermVectorsOperationDescriptor(Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultiTermVectorsOperationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor(Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation instance) => new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An artificial document (a document not present in the index) for which you want to retrieve term vectors.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Doc(object? value)
	{
		Instance.Doc = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// Used as the default list unless a specific field list is provided in the <c>completion_fields</c> or <c>fielddata_fields</c> parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// Used as the default list unless a specific field list is provided in the <c>completion_fields</c> or <c>fielddata_fields</c> parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the document count, sum of document frequencies, and sum of total term frequencies.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor FieldStatistics(bool? value = true)
	{
		Instance.FieldStatistics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Filter(Elastic.Clients.Elasticsearch.Core.TermVectors.Filter? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Filter()
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter terms based on their tf-idf scores.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor>? action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The index of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term offsets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Offsets(bool? value = true)
	{
		Instance.Offsets = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term payloads.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Payloads(bool? value = true)
	{
		Instance.Payloads = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes term positions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Positions(bool? value = true)
	{
		Instance.Positions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the response includes term frequency and document frequency.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor TermStatistics(bool? value = true)
	{
		Instance.TermStatistics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specific version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation Build(System.Action<Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperationDescriptor(new Elastic.Clients.Elasticsearch.Core.Mtermvectors.MultiTermVectorsOperation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}