// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.MSearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.MSearch.Json.MultisearchBodyConverter))]
public sealed partial class MultisearchBody
{
#if NET7_0_OR_GREATER
	public MultisearchBody()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MultisearchBody()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? Aggregations { get; set; }

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? Collapse { get; set; }

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? DocvalueFields { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public bool? Explain { get; set; }

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Ext { get; set; }

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// The starting document offset, which must be non-negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public int? From { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.Highlight? Highlight { get; set; }

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? IndicesBoost { get; set; }

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? Knn { get; set; }

	/// <summary>
	/// <para>
	/// The minimum <c>_score</c> for matching documents.
	/// Documents with a lower <c>_score</c> are not included in search results or results collected by aggregations.
	/// </para>
	/// </summary>
	public double? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? Pit { get; set; }

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? PostFilter { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return detailed timing information about the execution of individual components in a search request.
	/// NOTE: This is a debugging tool and adds significant overhead to search execution.
	/// </para>
	/// </summary>
	public bool? Profile { get; set; }

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rank? Rank { get; set; }

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? Rescore { get; set; }

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Retriever? Retriever { get; set; }

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? ScriptFields { get; set; }

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? SearchAfter { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns sequence number and primary term of the last modification of each hit.
	/// </para>
	/// </summary>
	public bool? SeqNoPrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The number of hits to return, which must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> property.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SlicedScroll? Slice { get; set; }

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? Source { get; set; }

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Stats { get; set; }

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? StoredFields { get; set; }

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.Suggester? Suggest { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of documents to collect for each shard.
	/// If a query reaches this limit, Elasticsearch terminates the query early.
	/// Elasticsearch collects documents before sorting.
	/// </para>
	/// <para>
	/// IMPORTANT: Use with caution.
	/// Elasticsearch applies this property to each shard handling the request.
	/// When possible, let Elasticsearch perform early termination automatically.
	/// Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
	/// </para>
	/// <para>
	/// If set to <c>0</c> (default), the query does not terminate early.
	/// </para>
	/// </summary>
	public long? TerminateAfter { get; set; }

	/// <summary>
	/// <para>
	/// The period of time to wait for a response from each shard.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public string? Timeout { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public bool? TrackScores { get; set; }

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.TrackHits? TrackTotalHits { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public bool? Version { get; set; }
}

public readonly partial struct MultisearchBodyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultisearchBodyDescriptor(Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultisearchBodyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody instance) => new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Ext(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Ext = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Ext()
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Ext(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddExt(string key, object value)
	{
		Instance.Ext ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Ext.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The starting document offset, which must be non-negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> IndicesBoost(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? value)
	{
		Instance.IndicesBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> IndicesBoost()
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> IndicesBoost(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble>? action)
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddIndicesBoost(Elastic.Clients.Elasticsearch.IndexName key, double value)
	{
		Instance.IndicesBoost ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>();
		Instance.IndicesBoost.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Knn(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? value)
	{
		Instance.Knn = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Knn(params Elastic.Clients.Elasticsearch.KnnSearch[] values)
	{
		Instance.Knn = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Knn(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum <c>_score</c> for matching documents.
	/// Documents with a lower <c>_score</c> are not included in search results or results collected by aggregations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Pit(Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? value)
	{
		Instance.Pit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Pit(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor> action)
	{
		Instance.Pit = Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> PostFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.PostFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> PostFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return detailed timing information about the execution of individual components in a search request.
	/// NOTE: This is a debugging tool and adds significant overhead to search execution.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Rank(Elastic.Clients.Elasticsearch.Rank? value)
	{
		Instance.Rank = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Rank(System.Action<Elastic.Clients.Elasticsearch.RankDescriptor> action)
	{
		Instance.Rank = Elastic.Clients.Elasticsearch.RankDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Rescore(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? value)
	{
		Instance.Rescore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Rescore(params Elastic.Clients.Elasticsearch.Core.Search.Rescore[] values)
	{
		Instance.Rescore = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Rescore(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Retriever(Elastic.Clients.Elasticsearch.Retriever? value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns sequence number and primary term of the last modification of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return, which must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Stats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Stats(params string[] values)
	{
		Instance.Stats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> StoredFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Suggest(Elastic.Clients.Elasticsearch.Core.Search.Suggester? value)
	{
		Instance.Suggest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Suggest()
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Suggest(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of documents to collect for each shard.
	/// If a query reaches this limit, Elasticsearch terminates the query early.
	/// Elasticsearch collects documents before sorting.
	/// </para>
	/// <para>
	/// IMPORTANT: Use with caution.
	/// Elasticsearch applies this property to each shard handling the request.
	/// When possible, let Elasticsearch perform early termination automatically.
	/// Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
	/// </para>
	/// <para>
	/// If set to <c>0</c> (default), the query does not terminate early.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> TerminateAfter(long? value)
	{
		Instance.TerminateAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period of time to wait for a response from each shard.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Timeout(string? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> TrackTotalHits(Elastic.Clients.Elasticsearch.Core.Search.TrackHits? value)
	{
		Instance.TrackTotalHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> TrackTotalHits(System.Func<Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory, Elastic.Clients.Elasticsearch.Core.Search.TrackHits> action)
	{
		Instance.TrackTotalHits = Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument> Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody Build(System.Action<Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct MultisearchBodyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultisearchBodyDescriptor(Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MultisearchBodyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor(Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody instance) => new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Aggregations<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddAggregation<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Collapse<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor DocvalueFields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Ext(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Ext = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Ext()
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Ext(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddExt(string key, object value)
	{
		Instance.Ext ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Ext.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Fields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The starting document offset, which must be non-negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Highlight<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor IndicesBoost(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? value)
	{
		Instance.IndicesBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor IndicesBoost()
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor IndicesBoost(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble>? action)
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddIndicesBoost(Elastic.Clients.Elasticsearch.IndexName key, double value)
	{
		Instance.IndicesBoost ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>();
		Instance.IndicesBoost.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Knn(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? value)
	{
		Instance.Knn = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Knn(params Elastic.Clients.Elasticsearch.KnnSearch[] values)
	{
		Instance.Knn = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Knn(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Knn<T>(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<T>.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum <c>_score</c> for matching documents.
	/// Documents with a lower <c>_score</c> are not included in search results or results collected by aggregations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Pit(Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? value)
	{
		Instance.Pit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Pit(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor> action)
	{
		Instance.Pit = Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor PostFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.PostFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor PostFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor PostFilter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return detailed timing information about the execution of individual components in a search request.
	/// NOTE: This is a debugging tool and adds significant overhead to search execution.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Rank(Elastic.Clients.Elasticsearch.Rank? value)
	{
		Instance.Rank = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Rank(System.Action<Elastic.Clients.Elasticsearch.RankDescriptor> action)
	{
		Instance.Rank = Elastic.Clients.Elasticsearch.RankDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Rescore(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? value)
	{
		Instance.Rescore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Rescore(params Elastic.Clients.Elasticsearch.Core.Search.Rescore[] values)
	{
		Instance.Rescore = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Rescore(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Rescore<T>(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<T>.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Retriever(Elastic.Clients.Elasticsearch.Retriever? value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Retriever<T>(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns sequence number and primary term of the last modification of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return, which must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Slice<T>(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Source<T>(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Stats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Stats(params string[] values)
	{
		Instance.Stats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor StoredFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Suggest(Elastic.Clients.Elasticsearch.Core.Search.Suggester? value)
	{
		Instance.Suggest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Suggest()
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Suggest(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Suggest<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<T>>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of documents to collect for each shard.
	/// If a query reaches this limit, Elasticsearch terminates the query early.
	/// Elasticsearch collects documents before sorting.
	/// </para>
	/// <para>
	/// IMPORTANT: Use with caution.
	/// Elasticsearch applies this property to each shard handling the request.
	/// When possible, let Elasticsearch perform early termination automatically.
	/// Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
	/// </para>
	/// <para>
	/// If set to <c>0</c> (default), the query does not terminate early.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor TerminateAfter(long? value)
	{
		Instance.TerminateAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period of time to wait for a response from each shard.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Timeout(string? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor TrackTotalHits(Elastic.Clients.Elasticsearch.Core.Search.TrackHits? value)
	{
		Instance.TrackTotalHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor TrackTotalHits(System.Func<Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory, Elastic.Clients.Elasticsearch.Core.Search.TrackHits> action)
	{
		Instance.TrackTotalHits = Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody Build(System.Action<Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBodyDescriptor(new Elastic.Clients.Elasticsearch.Core.MSearch.MultisearchBody(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}