// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.HealthReport.Json;

public sealed partial class SlmIndicatorDetailsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.HealthReport.SlmIndicatorDetails>
{
	private static readonly System.Text.Json.JsonEncodedText PropPolicies = System.Text.Json.JsonEncodedText.Encode("policies");
	private static readonly System.Text.Json.JsonEncodedText PropSlmStatus = System.Text.Json.JsonEncodedText.Encode("slm_status");
	private static readonly System.Text.Json.JsonEncodedText PropUnhealthyPolicies = System.Text.Json.JsonEncodedText.Encode("unhealthy_policies");

	public override Elastic.Clients.Elasticsearch.Core.HealthReport.SlmIndicatorDetails Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propPolicies = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.LifecycleOperationMode> propSlmStatus = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.HealthReport.SlmIndicatorUnhealthyPolicies?> propUnhealthyPolicies = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propPolicies.TryReadProperty(ref reader, options, PropPolicies, null))
			{
				continue;
			}

			if (propSlmStatus.TryReadProperty(ref reader, options, PropSlmStatus, null))
			{
				continue;
			}

			if (propUnhealthyPolicies.TryReadProperty(ref reader, options, PropUnhealthyPolicies, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.HealthReport.SlmIndicatorDetails(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Policies = propPolicies.Value,
			SlmStatus = propSlmStatus.Value,
			UnhealthyPolicies = propUnhealthyPolicies.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.HealthReport.SlmIndicatorDetails value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropPolicies, value.Policies, null, null);
		writer.WriteProperty(options, PropSlmStatus, value.SlmStatus, null, null);
		writer.WriteProperty(options, PropUnhealthyPolicies, value.UnhealthyPolicies, null, null);
		writer.WriteEndObject();
	}
}