// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.HealthReport.Json;

public sealed partial class IndicatorHealthStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGreen = System.Text.Json.JsonEncodedText.Encode("green");
	private static readonly System.Text.Json.JsonEncodedText MemberRed = System.Text.Json.JsonEncodedText.Encode("red");
	private static readonly System.Text.Json.JsonEncodedText MemberUnavailable = System.Text.Json.JsonEncodedText.Encode("unavailable");
	private static readonly System.Text.Json.JsonEncodedText MemberUnknown = System.Text.Json.JsonEncodedText.Encode("unknown");
	private static readonly System.Text.Json.JsonEncodedText MemberYellow = System.Text.Json.JsonEncodedText.Encode("yellow");

	public override Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGreen))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Green;
		}

		if (reader.ValueTextEquals(MemberRed))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Red;
		}

		if (reader.ValueTextEquals(MemberUnavailable))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Unavailable;
		}

		if (reader.ValueTextEquals(MemberUnknown))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Unknown;
		}

		if (reader.ValueTextEquals(MemberYellow))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Yellow;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGreen.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Green;
		}

		if (string.Equals(value, MemberRed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Red;
		}

		if (string.Equals(value, MemberUnavailable.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Unavailable;
		}

		if (string.Equals(value, MemberUnknown.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Unknown;
		}

		if (string.Equals(value, MemberYellow.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Yellow;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Green:
				writer.WriteStringValue(MemberGreen);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Red:
				writer.WriteStringValue(MemberRed);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Unavailable:
				writer.WriteStringValue(MemberUnavailable);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Unknown:
				writer.WriteStringValue(MemberUnknown);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus.Yellow:
				writer.WriteStringValue(MemberYellow);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.HealthReport.IndicatorHealthStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}