// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.HealthReport.Json;

public sealed partial class ImpactAreaConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBackup = System.Text.Json.JsonEncodedText.Encode("backup");
	private static readonly System.Text.Json.JsonEncodedText MemberDeploymentManagement = System.Text.Json.JsonEncodedText.Encode("deployment_management");
	private static readonly System.Text.Json.JsonEncodedText MemberIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText MemberSearch = System.Text.Json.JsonEncodedText.Encode("search");

	public override Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBackup))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Backup;
		}

		if (reader.ValueTextEquals(MemberDeploymentManagement))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.DeploymentManagement;
		}

		if (reader.ValueTextEquals(MemberIngest))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Ingest;
		}

		if (reader.ValueTextEquals(MemberSearch))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Search;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBackup.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Backup;
		}

		if (string.Equals(value, MemberDeploymentManagement.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.DeploymentManagement;
		}

		if (string.Equals(value, MemberIngest.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Ingest;
		}

		if (string.Equals(value, MemberSearch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Search;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Backup:
				writer.WriteStringValue(MemberBackup);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.DeploymentManagement:
				writer.WriteStringValue(MemberDeploymentManagement);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Ingest:
				writer.WriteStringValue(MemberIngest);
				break;
			case Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea.Search:
				writer.WriteStringValue(MemberSearch);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.HealthReport.ImpactArea value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}