// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.HealthReport.Json;

public sealed partial class DiagnosisConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.HealthReport.Diagnosis>
{
	private static readonly System.Text.Json.JsonEncodedText PropAction = System.Text.Json.JsonEncodedText.Encode("action");
	private static readonly System.Text.Json.JsonEncodedText PropAffectedResources = System.Text.Json.JsonEncodedText.Encode("affected_resources");
	private static readonly System.Text.Json.JsonEncodedText PropCause = System.Text.Json.JsonEncodedText.Encode("cause");
	private static readonly System.Text.Json.JsonEncodedText PropHelpUrl = System.Text.Json.JsonEncodedText.Encode("help_url");
	private static readonly System.Text.Json.JsonEncodedText PropId = System.Text.Json.JsonEncodedText.Encode("id");

	public override Elastic.Clients.Elasticsearch.Core.HealthReport.Diagnosis Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propAction = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Core.HealthReport.DiagnosisAffectedResources> propAffectedResources = default;
		LocalJsonValue<string> propCause = default;
		LocalJsonValue<string> propHelpUrl = default;
		LocalJsonValue<string> propId = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAction.TryReadProperty(ref reader, options, PropAction, null))
			{
				continue;
			}

			if (propAffectedResources.TryReadProperty(ref reader, options, PropAffectedResources, null))
			{
				continue;
			}

			if (propCause.TryReadProperty(ref reader, options, PropCause, null))
			{
				continue;
			}

			if (propHelpUrl.TryReadProperty(ref reader, options, PropHelpUrl, null))
			{
				continue;
			}

			if (propId.TryReadProperty(ref reader, options, PropId, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Core.HealthReport.Diagnosis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Action = propAction.Value,
			AffectedResources = propAffectedResources.Value,
			Cause = propCause.Value,
			HelpUrl = propHelpUrl.Value,
			Id = propId.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.HealthReport.Diagnosis value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAction, value.Action, null, null);
		writer.WriteProperty(options, PropAffectedResources, value.AffectedResources, null, null);
		writer.WriteProperty(options, PropCause, value.Cause, null, null);
		writer.WriteProperty(options, PropHelpUrl, value.HelpUrl, null, null);
		writer.WriteProperty(options, PropId, value.Id, null, null);
		writer.WriteEndObject();
	}
}