// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Get;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Get.Json.GetResultConverterFactory))]
public sealed partial class GetResult<TDocument>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetResult(bool found, string id, string index)
	{
		Found = found;
		Id = id;
		Index = index;
	}
#if NET7_0_OR_GREATER
	public GetResult()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GetResult()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetResult(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the <c>stored_fields</c> parameter is set to <c>true</c> and <c>found</c> is <c>true</c>, it contains the document fields stored in the index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the document exists.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Found { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<string>? Ignored { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index the document belongs to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Index { get; set; }

	/// <summary>
	/// <para>
	/// The primary term assigned to the document for the indexing operation.
	/// </para>
	/// </summary>
	public long? PrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The explicit routing, if set.
	/// </para>
	/// </summary>
	public string? Routing { get; set; }

	/// <summary>
	/// <para>
	/// The sequence number assigned to the document for the indexing operation.
	/// Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version.
	/// </para>
	/// </summary>
	public long? SeqNo { get; set; }

	/// <summary>
	/// <para>
	/// If <c>found</c> is <c>true</c>, it contains the document data formatted in JSON.
	/// If the <c>_source</c> parameter is set to <c>false</c> or the <c>stored_fields</c> parameter is set to <c>true</c>, it is excluded.
	/// </para>
	/// </summary>
	public TDocument? Source { get; set; }

	/// <summary>
	/// <para>
	/// The document version, which is ncremented each time the document is updated.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}