// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.FieldCaps;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.FieldCaps.Json.FieldCapabilityConverter))]
public sealed partial class FieldCapability
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldCapability(bool aggregatable, bool searchable, string type)
	{
		Aggregatable = aggregatable;
		Searchable = searchable;
		Type = type;
	}
#if NET7_0_OR_GREATER
	public FieldCapability()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FieldCapability()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldCapability(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Whether this field can be aggregated on all indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Aggregatable { get; set; }

	/// <summary>
	/// <para>
	/// The list of indices where this field has the same type family, or null if all indices have the same type family for the field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Indices { get; set; }

	/// <summary>
	/// <para>
	/// Merged metadata across all indices as a map of string keys to arrays of values. A value length of 1 indicates that all indices had the same value for this key, while a length of 2 or more indicates that not all indices had the same value for this key.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Whether this field is registered as a metadata field.
	/// </para>
	/// </summary>
	public bool? MetadataField { get; set; }

	/// <summary>
	/// <para>
	/// The list of indices where this field is present if these indices
	/// don’t have the same <c>time_series_metric</c> value for this field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<string>? MetricConflictsIndices { get; set; }

	/// <summary>
	/// <para>
	/// The list of indices where this field is not aggregatable, or null if all indices have the same definition for the field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? NonAggregatableIndices { get; set; }

	/// <summary>
	/// <para>
	/// If this list is present in response then some indices have the
	/// field marked as a dimension and other indices, the ones in this list, do not.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<string>? NonDimensionIndices { get; set; }

	/// <summary>
	/// <para>
	/// The list of indices where this field is not searchable, or null if all indices have the same definition for the field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? NonSearchableIndices { get; set; }

	/// <summary>
	/// <para>
	/// Whether this field is indexed for search on all indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Searchable { get; set; }

	/// <summary>
	/// <para>
	/// Whether this field is used as a time series dimension.
	/// </para>
	/// </summary>
	public bool? TimeSeriesDimension { get; set; }

	/// <summary>
	/// <para>
	/// Contains metric type if this fields is used as a time series
	/// metrics, absent if the field is not used as metric.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.TimeSeriesMetricType? TimeSeriesMetric { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Type { get; set; }
}