// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

/// <summary>
/// <para>
/// Text or location that we want similar documents for or a lookup to a document's field for the text.
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-mlt-query#_document_input_parameters">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.ContextConverter))]
public sealed partial class Context : Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.GeoLocation>
{
	public Context(string value) : base(value)
	{
	}

	public Context(Elastic.Clients.Elasticsearch.GeoLocation value) : base(value)
	{
	}

	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Context(string value) => new Elastic.Clients.Elasticsearch.Core.Search.Context(value);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Context(Elastic.Clients.Elasticsearch.GeoLocation value) => new Elastic.Clients.Elasticsearch.Core.Search.Context(value);
}

public readonly partial struct ContextFactory
{
	public Elastic.Clients.Elasticsearch.Core.Search.Context Category(string value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.Context(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.Context Location(Elastic.Clients.Elasticsearch.GeoLocation value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.Context(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.Context Location(System.Func<Elastic.Clients.Elasticsearch.GeoLocationFactory, Elastic.Clients.Elasticsearch.GeoLocation> action)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.Context(Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(action));
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.Context Build(System.Func<Elastic.Clients.Elasticsearch.Core.Search.ContextFactory, Elastic.Clients.Elasticsearch.Core.Search.Context> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.ContextFactory();
		return action.Invoke(builder);
	}
}