// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Bulk;

public abstract partial class ResponseItem
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ResponseItem(string index, int status)
	{
		Index = index;
		Status = status;
	}
#if NET7_0_OR_GREATER
	public ResponseItem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ResponseItem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ResponseItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Additional information about the failed operation.
	/// The property is returned only for failed operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ErrorCause? Error { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus? FailureStore { get; set; }
	public bool? ForcedRefresh { get; set; }
	public Elastic.Clients.Elasticsearch.InlineGet<System.Collections.Generic.IReadOnlyDictionary<string, object>>? Get { get; set; }

	/// <summary>
	/// <para>
	/// The document ID associated with the operation.
	/// </para>
	/// </summary>
	public string? Id { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index associated with the operation.
	/// If the operation targeted a data stream, this is the backing index into which the document was written.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Index { get; set; }

	/// <summary>
	/// <para>
	/// The primary term assigned to the document for the operation.
	/// This property is returned only for successful operations.
	/// </para>
	/// </summary>
	public long? PrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The result of the operation.
	/// Successful values are <c>created</c>, <c>deleted</c>, and <c>updated</c>.
	/// </para>
	/// </summary>
	public string? Result { get; set; }

	/// <summary>
	/// <para>
	/// The sequence number assigned to the document for the operation.
	/// Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version.
	/// </para>
	/// </summary>
	public long? SeqNo { get; set; }

	/// <summary>
	/// <para>
	/// Shard information for the operation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ShardStatistics? Shards { get; set; }

	/// <summary>
	/// <para>
	/// The HTTP status code returned for the operation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Status { get; set; }

	/// <summary>
	/// <para>
	/// The document version associated with the operation.
	/// The document version is incremented each time the document is updated.
	/// This property is returned only for successful actions.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}