// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Bulk.Json;

public sealed partial class OperationTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Bulk.OperationType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCreate = System.Text.Json.JsonEncodedText.Encode("create");
	private static readonly System.Text.Json.JsonEncodedText MemberDelete = System.Text.Json.JsonEncodedText.Encode("delete");
	private static readonly System.Text.Json.JsonEncodedText MemberIndex = System.Text.Json.JsonEncodedText.Encode("index");
	private static readonly System.Text.Json.JsonEncodedText MemberUpdate = System.Text.Json.JsonEncodedText.Encode("update");

	public override Elastic.Clients.Elasticsearch.Core.Bulk.OperationType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCreate))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Create;
		}

		if (reader.ValueTextEquals(MemberDelete))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Delete;
		}

		if (reader.ValueTextEquals(MemberIndex))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Index;
		}

		if (reader.ValueTextEquals(MemberUpdate))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Update;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCreate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Create;
		}

		if (string.Equals(value, MemberDelete.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Delete;
		}

		if (string.Equals(value, MemberIndex.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Index;
		}

		if (string.Equals(value, MemberUpdate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Update;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Bulk.OperationType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Bulk.OperationType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Create:
				writer.WriteStringValue(MemberCreate);
				break;
			case Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Delete:
				writer.WriteStringValue(MemberDelete);
				break;
			case Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Index:
				writer.WriteStringValue(MemberIndex);
				break;
			case Elastic.Clients.Elasticsearch.Core.Bulk.OperationType.Update:
				writer.WriteStringValue(MemberUpdate);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Bulk.OperationType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Bulk.OperationType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Bulk.OperationType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}