// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Bulk.Json;

public sealed partial class FailureStoreStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("failed");
	private static readonly System.Text.Json.JsonEncodedText MemberNotApplicableOrUnknown = System.Text.Json.JsonEncodedText.Encode("not_applicable_or_unknown");
	private static readonly System.Text.Json.JsonEncodedText MemberNotEnabled = System.Text.Json.JsonEncodedText.Encode("not_enabled");
	private static readonly System.Text.Json.JsonEncodedText MemberUsed = System.Text.Json.JsonEncodedText.Encode("used");

	public override Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.Failed;
		}

		if (reader.ValueTextEquals(MemberNotApplicableOrUnknown))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.NotApplicableOrUnknown;
		}

		if (reader.ValueTextEquals(MemberNotEnabled))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.NotEnabled;
		}

		if (reader.ValueTextEquals(MemberUsed))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.Used;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.Failed;
		}

		if (string.Equals(value, MemberNotApplicableOrUnknown.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.NotApplicableOrUnknown;
		}

		if (string.Equals(value, MemberNotEnabled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.NotEnabled;
		}

		if (string.Equals(value, MemberUsed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.Used;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.NotApplicableOrUnknown:
				writer.WriteStringValue(MemberNotApplicableOrUnknown);
				break;
			case Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.NotEnabled:
				writer.WriteStringValue(MemberNotEnabled);
				break;
			case Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus.Used:
				writer.WriteStringValue(MemberUsed);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Bulk.FailureStoreStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}