// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class CoordsGeoBoundsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.CoordsGeoBounds>
{
	private static readonly System.Text.Json.JsonEncodedText PropBottom = System.Text.Json.JsonEncodedText.Encode("bottom");
	private static readonly System.Text.Json.JsonEncodedText PropLeft = System.Text.Json.JsonEncodedText.Encode("left");
	private static readonly System.Text.Json.JsonEncodedText PropRight = System.Text.Json.JsonEncodedText.Encode("right");
	private static readonly System.Text.Json.JsonEncodedText PropTop = System.Text.Json.JsonEncodedText.Encode("top");

	public override Elastic.Clients.Elasticsearch.CoordsGeoBounds Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<double> propBottom = default;
		LocalJsonValue<double> propLeft = default;
		LocalJsonValue<double> propRight = default;
		LocalJsonValue<double> propTop = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBottom.TryReadProperty(ref reader, options, PropBottom, null))
			{
				continue;
			}

			if (propLeft.TryReadProperty(ref reader, options, PropLeft, null))
			{
				continue;
			}

			if (propRight.TryReadProperty(ref reader, options, PropRight, null))
			{
				continue;
			}

			if (propTop.TryReadProperty(ref reader, options, PropTop, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.CoordsGeoBounds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Bottom = propBottom.Value,
			Left = propLeft.Value,
			Right = propRight.Value,
			Top = propTop.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.CoordsGeoBounds value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBottom, value.Bottom, null, null);
		writer.WriteProperty(options, PropLeft, value.Left, null, null);
		writer.WriteProperty(options, PropRight, value.Right, null, null);
		writer.WriteProperty(options, PropTop, value.Top, null, null);
		writer.WriteEndObject();
	}
}