// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class ConflictsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Conflicts>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAbort = System.Text.Json.JsonEncodedText.Encode("abort");
	private static readonly System.Text.Json.JsonEncodedText MemberProceed = System.Text.Json.JsonEncodedText.Encode("proceed");

	public override Elastic.Clients.Elasticsearch.Conflicts Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAbort))
		{
			return Elastic.Clients.Elasticsearch.Conflicts.Abort;
		}

		if (reader.ValueTextEquals(MemberProceed))
		{
			return Elastic.Clients.Elasticsearch.Conflicts.Proceed;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAbort.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Conflicts.Abort;
		}

		if (string.Equals(value, MemberProceed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Conflicts.Proceed;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Conflicts)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Conflicts value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Conflicts.Abort:
				writer.WriteStringValue(MemberAbort);
				break;
			case Elastic.Clients.Elasticsearch.Conflicts.Proceed:
				writer.WriteStringValue(MemberProceed);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Conflicts)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Conflicts ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Conflicts value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}