// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class ClusterStatisticsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.ClusterStatistics>
{
	private static readonly System.Text.Json.JsonEncodedText PropDetails = System.Text.Json.JsonEncodedText.Encode("details");
	private static readonly System.Text.Json.JsonEncodedText PropFailed = System.Text.Json.JsonEncodedText.Encode("failed");
	private static readonly System.Text.Json.JsonEncodedText PropPartial = System.Text.Json.JsonEncodedText.Encode("partial");
	private static readonly System.Text.Json.JsonEncodedText PropRunning = System.Text.Json.JsonEncodedText.Encode("running");
	private static readonly System.Text.Json.JsonEncodedText PropSkipped = System.Text.Json.JsonEncodedText.Encode("skipped");
	private static readonly System.Text.Json.JsonEncodedText PropSuccessful = System.Text.Json.JsonEncodedText.Encode("successful");
	private static readonly System.Text.Json.JsonEncodedText PropTotal = System.Text.Json.JsonEncodedText.Encode("total");

	public override Elastic.Clients.Elasticsearch.ClusterStatistics Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.ClusterDetails>?> propDetails = default;
		LocalJsonValue<int> propFailed = default;
		LocalJsonValue<int> propPartial = default;
		LocalJsonValue<int> propRunning = default;
		LocalJsonValue<int> propSkipped = default;
		LocalJsonValue<int> propSuccessful = default;
		LocalJsonValue<int> propTotal = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDetails.TryReadProperty(ref reader, options, PropDetails, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.ClusterDetails>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.ClusterDetails>(o, null, null)))
			{
				continue;
			}

			if (propFailed.TryReadProperty(ref reader, options, PropFailed, null))
			{
				continue;
			}

			if (propPartial.TryReadProperty(ref reader, options, PropPartial, null))
			{
				continue;
			}

			if (propRunning.TryReadProperty(ref reader, options, PropRunning, null))
			{
				continue;
			}

			if (propSkipped.TryReadProperty(ref reader, options, PropSkipped, null))
			{
				continue;
			}

			if (propSuccessful.TryReadProperty(ref reader, options, PropSuccessful, null))
			{
				continue;
			}

			if (propTotal.TryReadProperty(ref reader, options, PropTotal, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.ClusterStatistics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Details = propDetails.Value,
			Failed = propFailed.Value,
			Partial = propPartial.Value,
			Running = propRunning.Value,
			Skipped = propSkipped.Value,
			Successful = propSuccessful.Value,
			Total = propTotal.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ClusterStatistics value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDetails, value.Details, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.ClusterDetails>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.ClusterDetails>(o, v, null, null));
		writer.WriteProperty(options, PropFailed, value.Failed, null, null);
		writer.WriteProperty(options, PropPartial, value.Partial, null, null);
		writer.WriteProperty(options, PropRunning, value.Running, null, null);
		writer.WriteProperty(options, PropSkipped, value.Skipped, null, null);
		writer.WriteProperty(options, PropSuccessful, value.Successful, null, null);
		writer.WriteProperty(options, PropTotal, value.Total, null, null);
		writer.WriteEndObject();
	}
}